package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author hutao
 * @since 2019-07-29
 */
@Data
@Api(tags = "TrSearchRecordeEntityVo", description = "")
@TableName("tr_search_recorde")
public class TrSearchRecorde extends Model<TrSearchRecorde> {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "主键")
	@TableId("id")
	private Long id;

	@ApiModelProperty(value = "终端类型1PC2微信3app")
	@TableField("terminal_type")
	private Integer terminalType;

	@ApiModelProperty(value = "类型 1全栈 2课程 3培训 4营销课程 5讲师库 6帖子")
	@TableField("type")
	private Integer type;

	@ApiModelProperty(value = "内容")
	@TableField("content")
	private String content;

	@ApiModelProperty(value = "0未删除1删除")
	@TableField("deleted")
	private Integer deleted;

	@TableField("account_id")
	private Long accountId;

	@TableField("org_id")
	private Long orgId;

	@TableField("site_id")
	private Long siteId;

	@TableField("company_id")
	private Long companyId;

	@TableField("create_time")
	private Date createTime;

	@TableField(value = "create_by_id", fill = FieldFill.INSERT)
	private Long createById;

	@TableField(value = "update_time", fill = FieldFill.INSERT)
	private Date updateTime;

	@TableField(value = "update_by_id", fill = FieldFill.INSERT)
	private Long updateById;

	@Override
	protected Serializable pkVal() {
		return this.id;
	}

}
