package com.yizhi.site.application.domain;

import java.io.Serializable;

import java.util.Date;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableName;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotations.Version;
import com.baomidou.mybatisplus.enums.FieldFill;
import lombok.Data;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * <p>
 * 专区（子站点）配置表
 * </p>
 *
 * @author taoge123
 * @since 2020-09-14
 */
@Data
@ApiModel(value = "TrSiteStudent", description = "专区（子站点）配置表")
@TableName("tr_site_student")
public class TrSiteStudent {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "id")
	private Long id;

	@ApiModelProperty(value = "配置的站点id")
	@TableField("student_site_id")
	private Long studentSiteId;

    @ApiModelProperty(value = "站点名称")
	@TableField("site_name")
	private String siteName;


    @ApiModelProperty(value = "是否在首页展示：0否，1是；默认1")
	private Integer enabled;

    @ApiModelProperty(value = "排序")
	private Integer sort;


    @ApiModelProperty(value = "1：删除 0：未删除")
	private Integer deleted;

	@ApiModelProperty(value = "站点id")
	@TableField("site_id")
	private Long siteId;

    @ApiModelProperty(value = "公司id")
	@TableField("company_id")
	private Long companyId;

    @ApiModelProperty(value = "创建者id")
	@TableField(value = "create_by_id", fill = FieldFill.INSERT)
	private Long createById;

    @ApiModelProperty(value = "创建者名称")
	@TableField(value = "create_by_name", fill = FieldFill.INSERT)
	private String createByName;

    @ApiModelProperty(value = "创建时间")
	@TableField(value = "create_time", fill = FieldFill.INSERT)
	private Date createTime;

    @ApiModelProperty(value = "修改时间")
	@TableField(value = "update_time", fill = FieldFill.INSERT)
	private Date updateTime;

    @ApiModelProperty(value = "修改人")
	@TableField(value = "update_by_id", fill = FieldFill.INSERT)
	private Long updateById;

    @ApiModelProperty(value = "修改人姓名")
	@TableField(value = "update_by_name", fill = FieldFill.INSERT)
	private String updateByName;



}
