package com.yizhi.site.application.service;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.IService;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.domain.International;
import com.yizhi.site.application.vo.site.InternationalImport;
import com.yizhi.site.application.vo.site.InternationalVO;
import com.yizhi.system.application.model.ImportModel;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author lilingye
 * @since 2020-08-13
 */
public interface IInternationalService extends IService<International> {
    /**
     * 国际化管理端返回的列表
     * @param type 0管理端 1 移动端 2 PC端
     * @param languageId
     * @param keywords
     * @param state  1:已翻译 0：未翻译 2:全部
     * @return LIST
     */
     List<InternationalVO> findInternationalList(Integer type, Long languageId, String keywords, Integer state);

    /**
     * 国际化管理端返回的列表
     * @param type
     * @param languageId
     * @param keywords
     * @param state
     * @param pageNo
     * @param pageSize
     * @return LIST
     */
     Page<InternationalVO> findInternationalPage(Integer type, Long languageId, String keywords, Integer state, Integer pageNo, Integer pageSize);


    /**
     * 导入国际化列表
     * @param importModel
     * @param context
     * @param languageId
     * @return
     */
     List<InternationalImport> importInternationalList(ImportModel importModel, RequestContext context, Long languageId, Integer type);

    /**
     * 修改国际化实体
     * @param internationalVO
     * @return
     */
     InternationalVO updateInternational(InternationalVO internationalVO);


    /**
     * 获取国际化value值得map
     * <internationalKeyId+languageId,internationalId>
     * @return
     */
    Map<String,Long> getValueMap(Long languageId);

}
