package com.yizhi.site.application.service;

import java.util.List;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.IService;
import com.yizhi.site.application.domain.PortalLogin;
import com.yizhi.site.application.domain.PortalTemplate;
import com.yizhi.site.application.domain.PortalTerminal;
import com.yizhi.site.application.vo.site.*;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
public interface PortalTerminalService extends IService<PortalTerminal> {

	/**
	 * 门户列表
	 * @param siteId
	 * @return
	 */
	List<TerminalListVO> listPortal(SiteComponyIdVO siteComponyIdVO);

	/**
	 * 门户发布
	 * @param terminalId
	 * @param state
	 * @return
	 */
	Long releasePortal(Long terminalId);
	
	/**
	 * quxiao 发布
	 * @param terminalId
	 * @return
	 */
	Long unReleasePortal(Long terminalId);

	/**
	 * 首页预览
	 * @param terminalId
	 * @return
	 */
	PortalPreviewVO previewPortal(Long terminalId);
	
	/**
	 * 首页发布
	 * @param homeId
	 * @return
	 */
	Long homeRelease(IdOneVO vo);
	
	/**
	 * 登录页配置（PC、微信）
	 * @param id
	 * @return
	 */
	PortalLogin loginPageView(Long terminalId);
	
	/**
	 * 登录页配置新增（PC、微信）
	 * @param terminalId
	 * @return
	 */
	Long loginPageInsert(PortalLoginListVO vo);

	/**
	 * 登录页修改（PC、微信）
	 * @param terminalId
	 * @return
	 */
	Long loginPageUpdate(PortalLogin pl);

	/**
	 * 登录页发布（PC、微信）
	 * @param id
	 * @return
	 */
	Long loginPageRelease(PortalLogin pl);

	/**
	 * 头部导航栏功能入口列表
	 * @param page
	 * @param terminalId
	 * @return
	 */
	HeadNavigateListVO listNavigate(PageParamVO vo);

	/**
	 *  功能入口新增 功能入口修改
	 * @param vo
	 * @return
	 */
	Boolean updateNavigate(NavigateListVO vo);
	

	/**
	 * 功能入口删除
	 * @param id
	 * @return
	 */
	boolean deleteNavigate(NavigateListVO vo);

	/**
	 * 功能入口新增
	 * @param list
	 * @return
	 */
	boolean insertListNavigate(NavigateInsertListVO vo);

	/**
	 * 已选择轮播图片列表
	 * @param terminalId
	 * @param page
	 * @return
	 */
	List<ImageListVO> listImage(Long homeId);

	/**
	 * 已选轮播图片删除
	 * @param terminalBannerId
	 * @return
	 */
	boolean deleteBannerImage(HomeImageListVO vo);

	/**
	 * 轮播图片预览
	 * @param bannerId
	 * @return
	 */
	String previewImage(Long imageId);
	
	/**
	 * 选择已有Banner列表
	 * @param terminalId
	 * @param page
	 * @return
	 */
	Page<ImageListVO> selectBannerImage(PageParamVO vo);

	/**
	 * 已选择轮播Banner新增集合
	 * @param list
	 * @return
	 */
	boolean insertBannerImageList(InsertListVO vo);

	/**
	 * 模块新增
	 * @param vo
	 * @return
	 */
	TemplateAddVO insertTemplate(TemplateAddVO vo);

	/**
	 * 模块删除
	 * @param id
	 * @return
	 */
	boolean deleteTemplate(PortalTemplate pt);

	/**
	 * 模块查看
	 * @param id
	 * @return
	 */
	TemplateListVO viewTemplate(Long templateId);

	/**
	 * 模块修改
	 * @param id
	 * @return
	 */
	Long updateTemplate(TemplateUpdateVO vo);

	/**
	 * 首页logo 新增
	 * @param vo
	 * @return
	 */
	Long insertHomeLogo(HomeLogoVO vo);

	/**
	 * 首页logo 修改
	 * @param vo
	 * @return
	 */
	Long updateHomeLogo(HomeLogoVO vo);

	/**
	 * 首页logo 查看
	 * @param vo
	 * @return
	 */
	HomeLogoVO viewHomeLogo(Long homeId);

	/**
	 * 选择公告列表
	 * @param vo
	 * @return
	 */
	Page<AnnouncementVO> selectAnnouncement(PageParamVO vo);

	/**
	 * 公告预览
	 * @param imformationId
	 * @return
	 */
	PreviewImformationVO previewAnnouncement(String imformationId);

	/**
	 * 添加公告列表
	 * @param vo
	 * @return
	 */
	Page<AnnouncementVO> listAnnouncement(PageParamVO vo);

	/**
	 * 添加公告 删除
	 * @param vo
	 * @return
	 */
	Boolean deleteAnnouncement(HomeInformationListVO vo);

	/**
	 * 添加公告 批量新增
	 * @param vo
	 * @return
	 */
	Boolean insertAnnouncementList(InsertListVO vo);

	/**
	 * 热门课程分类 列表
	 * @param templateId
	 * @return
	 */
	List<PopCourseListVO> ListTemplateCourse(Long templateId);

	/**
	 * 热门课程分类 新增
	 * @param listVo
	 * @return
	 */
	boolean insertTemplateCourse(CourseAddVO listVo);

	/**
	 * 新闻资讯列表
	 * @param templateId
	 * @return
	 */
	List<TemplateNewsVO> listSelectedNews(Long templateId);

	/**
	 * 新闻资讯 预览
	 * @param id
	 * @return
	 */
	PreviewNewsVO previewNews(Long id);

	/**
	 * 新闻资讯 新增
	 * @param vo
	 * @return
	 */
	boolean insertTemplateNews(NewsAddVO vo);

	/**
	 * 首页除模板外的所有
	 * @param terminalId
	 * @return
	 */
	PortalHomeOtherVO listHomeOther(HomeTerminalVo htvo);

	/**
	 * 首页正文
	 * @param terminalId
	 * @return
	 */
	List<ApiTemplateMiddlerVO> listHomeTemplate(HomeTerminalVo htvo);

	/**
	 * 添加新的banner
	 * @param vo
	 * @return
	 */
	Long uploadBannerImage(UploadImageVO vo);

	/**
	 * 已选择轮播图片 拖动排序
	 * @param vo
	 * @return
	 */
	Boolean dragImage(IdTwoVO vo);

	/**
	 * 导航栏排序
	 * @param vo
	 * @return
	 */
	Boolean dragNavigate(IdTwoVO vo);

	/**
	 * 获取登录页 
	 * @param siteId
	 * @param type
	 * @return
	 */
	PortalLogin loginPageView(Long siteId, Integer type);

	/**
	 * 获取TerminalId
	 * @param htvo
	 * @return
	 */
	public Long getTerminalId(HomeTerminalVo htvo);


    Integer canVisit(Integer type);
}
