package com.yizhi.site.application.service;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.IService;
import com.yizhi.site.application.domain.Publication;
import com.yizhi.site.application.vo.site.*;

import java.util.List;

/**
 * com.yizhi.site.application.service
 *
 * @author yanglang
 * @create 2024-12-17 14:34:33
 */
public interface PublicationService extends IService<Publication> {

    /**
     * 根据分类id查询资讯
     */
    List<Publication> selectPublication(Long typeTwo);

    Page<Publication> publicationList(PublicationParamVO vo);

    Long insertPublication(Publication publication);

    /**
     * 资讯发布（批量）
     */
    boolean releases(ParamVO vo);

    /**
     * 新闻资讯上架
     *
     * @param id 新闻公告id
     * @return
     */

    boolean releasePublication(Long id );

    /**
     * 资讯取消发布（批量）
     */
    boolean unreleases(ParamVO vo);

    /**
     * 根据新闻,公告查询资讯
     */
    Page<PublicationStudentVO> publicationList(Long typeOne, Integer pageNo, Integer pageSize, Long siteId);

    /**
     * 根据id查询资讯
     */
    Publication getPublication(Long id, Long siteId);

    /**
     * 首页 搜索新闻公告
     */
    List<Publication> searchPublication(Page<Publication> page, Publication info);

    /**
     * 轮播图 类型 新闻模糊搜索
     */
    List<Publication> listbyName(String name, Long siteId);

    Publication publicationView(Long id);


    boolean approve( Long id);

    boolean unApprove( Long id);


    /**
     * ----------------------华丽的分割线---------------------------------
     */

    List<Publication> getRelationAnnouncementPC(Long terminalId);


    Page<Publication> getPublicationByTypeOne(Long typeOne,Integer pageNo,Integer pageSize,Long siteId,List<Long> listIds);



    Page<Publication> getAllAnnouncementPC(Long terminalId,Integer pageNo,Integer pageSize);


    Page<Publication> getAllNewsPC(Long terminalId,Integer pageNo,Integer pageSize);


    List<Publication> getRelationPublication(Long id);



    List<Publication> listSupplyPublication(Long siteId,List<Long> ids);


    Page<Publication> publicationReleaseList(PublicationParamReleaseVO vo);

}
