package com.yizhi.site.application.service.impl;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
//import com.yizhi.application.job.remote.JobClient;
//import com.yizhi.application.job.remote.vo.VmyJobVO;
import com.yizhi.site.application.mapper.PortalBannerMapper;
import com.yizhi.site.application.mapper.PortalImageMapper;
import com.yizhi.site.application.constant.SiteConstant;
import com.yizhi.site.application.constant.SiteEnum;
import com.yizhi.point.application.feign.PointFeignClients;
import com.yizhi.point.application.vo.domain.PointVo;
import com.yizhi.site.application.domain.*;
import com.yizhi.site.application.service.*;
import com.yizhi.site.application.vo.site.*;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.util.application.date.DateUtil;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Calendar;
import java.util.*;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@Service
@Transactional
@Log4j2
public class PortalBannerServiceImpl extends ServiceImpl<PortalBannerMapper, PortalBanner> implements PortalBannerService {

    @Autowired
    IdGenerator idGenerator;
    @Autowired
    PortalBannerMapper portalBannerMapper;
    @Autowired
    PortalImageMapper portalImageMapper;
    @Autowired
    PortalImageService portalImageService;
    @Autowired
    PortalTerminalService portalTerminalService;
    @Autowired
    PortalBannerService portalBannerService;
    @Autowired
    InformationService informationService;
    @Autowired
    private PortalHomeService portalHomeService;
    @Autowired
    private PointFeignClients pointFeignClients;

//    @Autowired
//    JobClient jobClient;

    private static final String jobGroup = "banner";

    public Long isExist(String terminalName, Long siteId, Long companyId) {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("terminal_name", terminalName);
        map.put("site_id", siteId);
        map.put("company_id", companyId);
        List<PortalTerminal> selectByMap = portalTerminalService.selectByMap(map);
        if (selectByMap.size() > 0) {
            return selectByMap.get(0).getId();
        }
        return null;
    }

    @Override
    public Long createTerminal(String terminalName, Long siteId, Long companyId, Long createById, String createByName, Date date, Long orgId, Integer type, 
    		Integer displayType) {
        PortalTerminal portalTerminal = new PortalTerminal();
        Long terminalId = idGenerator.generate();
        portalTerminal.setId(terminalId);
        portalTerminal.setTerminalName(terminalName);
        portalTerminal.setSiteId(siteId);
        portalTerminal.setCreateById(createById);
        portalTerminal.setCreateByName(createByName);
        portalTerminal.setUpdateById(createById);
        portalTerminal.setUpdateByName(createByName);
        portalTerminal.setState(SiteConstant.ZERO);
        portalTerminal.setCompanyId(companyId);
        portalTerminal.setOrgId(orgId);
        portalTerminal.setCreateTime(date);
        portalTerminal.setUpdateTime(date);
        portalTerminal.setType(type);
        portalTerminal.setDisplay(displayType);
        portalTerminalService.insert(portalTerminal);
        return terminalId;
    }

    @Override
    public void createBanner(Long terminalId, Long siteId, Long createById, String createByName, Date date) {
        List<PortalBanner> list = new ArrayList<PortalBanner>();
        PortalBanner pb1 = new PortalBanner();
        pb1.setId(idGenerator.generate());
        pb1.setTerminalId(terminalId);
        pb1.setBannerName("首页");
        pb1.setState(SiteConstant.FIRST);
        pb1.setSiteId(siteId);
        pb1.setCreateById(createById);
        pb1.setCreateByName(createByName);
        pb1.setCreateTime(date);
        list.add(pb1);

        PortalBanner pb2 = new PortalBanner();
        pb2.setId(idGenerator.generate());
        pb2.setTerminalId(terminalId);
        pb2.setBannerName("项目");
        pb2.setState(SiteConstant.FIRST);
        pb2.setSiteId(siteId);
        pb2.setCreateById(createById);
        pb2.setCreateByName(createByName);
        pb2.setCreateTime(date);
        list.add(pb2);

        PortalBanner pb3 = new PortalBanner();
        pb3.setId(idGenerator.generate());
        pb3.setTerminalId(terminalId);
        pb3.setBannerName("课程");
        pb3.setState(SiteConstant.FIRST);
        pb3.setSiteId(siteId);
        pb3.setCreateById(createById);
        pb3.setCreateByName(createByName);
        pb3.setCreateTime(date);
        list.add(pb3);

        PortalBanner pb4 = new PortalBanner();
        pb4.setId(idGenerator.generate());
        pb4.setTerminalId(terminalId);
        pb4.setBannerName("新闻资讯");
        pb4.setState(SiteConstant.FIRST);
        pb4.setSiteId(siteId);
        pb4.setCreateById(createById);
        pb4.setCreateByName(createByName);
        pb4.setCreateTime(date);
        list.add(pb4);

        PortalBanner pb5 = new PortalBanner();
        pb5.setId(idGenerator.generate());
        pb5.setTerminalId(terminalId);
        pb5.setBannerName("营销");
        pb5.setState(SiteConstant.FIRST);
        pb5.setSiteId(siteId);
        pb5.setCreateById(createById);
        pb5.setCreateByName(createByName);
        pb5.setCreateTime(date);
        list.add(pb5);

        PortalBanner pb6 = new PortalBanner();
        pb6.setId(idGenerator.generate());
        pb6.setTerminalId(terminalId);
        pb6.setBannerName("专辑");
        pb6.setState(SiteConstant.FIRST);
        pb6.setSiteId(siteId);
        pb6.setCreateById(createById);
        pb6.setCreateByName(createByName);
        pb6.setCreateTime(date);
        list.add(pb6);

        if (list.size() > 0) {
            this.insertBatch(list);
        }
    }

    /**
     * @param id   bannerId
     * @return
     */
    @Override
    public boolean timeUpBanner(Long id) {
//
//        PortalImage portalImage = portalImageMapper.selectById(id);
//
//        // 批处理时间要在当前时间前十分钟哦
//        Calendar nowTime = Calendar.getInstance();
//        nowTime.add(Calendar.MINUTE, -10);
//
//
//        try {
//            VmyJobVO job = new VmyJobVO();
//            job.setGroup(jobGroup);
//            job.setJobName(id.toString());
//            job.setJobClassName("com.yizhi.application.handle.quartz.job.BannerUpJob");
//            String cron = DateUtil.getCron(portalImage.getAddTime());
//            String[] cronArr = cron.split(" ");
//            job.setSecond(cronArr[0]);
//            job.setMinute(cronArr[1]);
//            job.setHour(cronArr[2]);
//            job.setDay(cronArr[3]);
//            job.setMonth(cronArr[4]);
//            job.setWeek(cronArr[5]);
//            job.setYear(cronArr[6]);
//            jobClient.insert(job);
//        } catch (Exception e) {
//            log.error("创建任务失败,id=" + id + "错误消息={}", e);
//        }

        return false;
    }

    @Override
    public boolean delete(Long id) {

//        log.info("删除job");
//        //删除自定义消息实体信息
//
//        try {
//            jobClient.delete(jobGroup + "." + id.toString());
//        } catch (Exception e) {
//            log.error("删除job失败", e);
////                throw new BizException(MessageError.DELETE_JOB_ERROR,MessageError.DELETE_JOB_ERROR_MSG);
//        }

        return true;
    }

    @Override
    public ReturnImageVO listPage(SiteComponyIdVO siteComponyIdVO) {
        ReturnImageVO vo = null;
        Integer pageNo = siteComponyIdVO.getPageNo();
        Integer pageSize = siteComponyIdVO.getPageSize();
        String bannerName = siteComponyIdVO.getBannerName();
        String terminalName = siteComponyIdVO.getTerminalName();
        Long companyId = siteComponyIdVO.getCompanyId();
        Long orgId = siteComponyIdVO.getOrgId();
        Long siteId = siteComponyIdVO.getSiteId();
        Long createById = siteComponyIdVO.getCreateById();
        String createByName = siteComponyIdVO.getCreateByName();
        Integer state = siteComponyIdVO.getState();

        List<PortalBannerVo> listPortal = null;

        //防止并发添加数据
        List<PortalBanner> sitePortal = portalBannerMapper.selectByTerminalName(terminalName, siteId, companyId);
        if (sitePortal == null || sitePortal.size() == 0) {
            listPortal = new ArrayList<PortalBannerVo>();
            synchronized (this) {
                sitePortal = portalBannerMapper.selectByTerminalName(terminalName, siteId, companyId);
                if (sitePortal == null || sitePortal.size() == 0) {
                	//创建站点积分配置
                	createSitePoint(siteId, companyId, createById, createByName, orgId);
                	
                    Date date = new Date();
                    Long id = isExist(terminalName, siteId, companyId);
                    if (id == null) {
                        Long pcId = createTerminal("PC", siteId, companyId, createById, createByName, date, orgId, SiteConstant.TERMINAL_TYPE_PC, SiteConstant.SHOW);
                        if (pcId != null) {
                            createPortalHome(pcId, createById, createByName, date);
                            createBanner(pcId, siteId, createById, createByName, date);
                        }
//                        Long appId = createTerminal("APP", siteId, companyId, createById, createByName, date, orgId, SiteConstant.TERMINAL_TYPE_APP, SiteConstant.HIDE);
//                        if (appId != null) {
//                            createPortalHome(appId, createById, createByName, date);
//                            createBanner(appId, siteId, createById, createByName, date);
//                        }
                        Long weChatId = createTerminal("移动端", siteId, companyId, createById, createByName, date, orgId, SiteConstant.TERMINAL_TYPE_WEIXIN, SiteConstant.SHOW);
                        if (weChatId != null) {
                            createPortalHome(weChatId, createById, createByName, date);
                            createBanner(weChatId, siteId, createById, createByName, date);
                        }
                    } else {
                        Long pcId = isExist("PC", siteId, companyId);
                        if (pcId != null) {
                            createPortalHome(pcId, createById, createByName, date);
                            createBanner(pcId, siteId, createById, createByName, date);
                        }
//                        Long appId = isExist("APP", siteId, companyId);
//                        if (appId != null) {
//                            createPortalHome(appId, createById, createByName, date);
//                            createBanner(appId, siteId, createById, createByName, date);
//                        }
                        Long weChatId = isExist("移动端", siteId, companyId);
                        if (weChatId != null) {
                            createPortalHome(weChatId, createById, createByName, date);
                            createBanner(weChatId, siteId, createById, createByName, date);
                        }
                    }
                }
            }
        }
        vo = new ReturnImageVO();
        List<Integer> stateList = new ArrayList<Integer>();
        if (state == 3) {
            stateList.add(1);
            stateList.add(2);
        } else {
            stateList.add(state);
        }
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("bannerName", bannerName);
        map.put("siteId", siteId);
        map.put("companyId", companyId);
        map.put("terminalName", terminalName);
        map.put("stateList", stateList);
        map.put("imgTitle", siteComponyIdVO.getImgTitle());
        Page<PortalBannerVo> page = new Page<PortalBannerVo>(pageNo, pageSize);
        listPortal = portalBannerMapper.selectPortalBanner(page, map);


        for (PortalBannerVo pb : listPortal) {
        	//null强制设置为0（不是首页）
        	if (null == pb.getHomeType()){
        		pb.setHomeType(0);
        	}
            if (pb.getHomeType() == 0) {  //  首页类型, 1：课程  2：考试   3：培训  4：外部链接   不是首页 0
                pb.setKind(SiteEnum.DETAIL.getValue());
                pb.setType(SiteEnum.getValueByKey(pb.getBannerName()));
            }
            if (pb.getHomeType() == 1) {
                pb.setKind(SiteEnum.DETAIL.getValue());
                pb.setType(SiteEnum.COURSE.getValue());
            } else if (pb.getHomeType() == 2) {
                pb.setKind(SiteEnum.DETAIL.getValue());
                pb.setType(SiteEnum.EXAM.getValue());
            } else if (pb.getHomeType() == 3) {
                pb.setKind(SiteEnum.DETAIL.getValue());
                pb.setType(SiteEnum.TRAIN.getValue());
            } else if (pb.getHomeType() == 4) {

            } else {

            }
        }
        page.setRecords(listPortal);
        vo.setPage(page);
        vo.setSiteId(siteId);
        Map<String, Object> ma = new HashMap<String, Object>();
        ma.put("site_id", siteId);
        ma.put("terminal_name", terminalName);
        ma.put("company_id", companyId);
        List<PortalTerminal> selectByMap = portalTerminalService.selectByMap(ma);
        if (selectByMap != null && selectByMap.size() > 0) {
            Long terminalId = selectByMap.get(0).getId();
            vo.setTerminalId(terminalId);
        }
        return vo;
    }

    @Override
    public Long insertDetail(BannerImageListVO vo) {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("terminal_id", vo.getTerminalId());
        map.put("banner_name", vo.getBannerName());
        map.put("site_id", vo.getSiteId());
        map.put("state", SiteConstant.FIRST);
        List<PortalBanner> selectByMap = portalBannerService.selectByMap(map);
        Long bannerId = null;
        Date date = new Date();
        if (selectByMap.size() > 0) {
            bannerId = selectByMap.get(0).getId();
        } else {
            bannerId = idGenerator.generate();
            PortalBanner pb = new PortalBanner();
            pb.setId(bannerId);
            pb.setBannerName(vo.getBannerName());
            pb.setTerminalId(vo.getTerminalId());
            pb.setSiteId(vo.getSiteId());
            pb.setCreateById(vo.getAccountId());
            pb.setCreateByName(vo.getAccountName());
            pb.setCreateTime(date);
            pb.setState(SiteConstant.FIRST);
            portalBannerService.insert(pb);
        }
        Integer sort = portalImageService.countImage(bannerId);
        if (sort == null) {
            sort = 0;
        }
        PortalImage pi = new PortalImage();
        Long imageId = idGenerator.generate();
        pi.setId(imageId);
        pi.setBannerId(bannerId);
        pi.setImgTitle(vo.getImgTitle());
        pi.setBannerPath(vo.getBannerPath());
        pi.setLinkUrl(vo.getLinkUrl());
        pi.setHomeType(vo.getHomeType());
        pi.setImgTitleSub(vo.getImgTitleSub());
        pi.setImgSource(vo.getImgSource());
        pi.setState(SiteConstant.TWO);
        pi.setCreateById(vo.getAccountId());
        pi.setCreateByName(vo.getAccountName());
        pi.setCreateTime(date);
        pi.setSort(sort + 1);
        if(vo.getAddTime()==null){
            vo.setAddTime(new Date());
        }
        pi.setAddTime(vo.getAddTime());

        // 判断时间
        Calendar nowDate = Calendar.getInstance();
        nowDate.setTime(date);
        //输入新闻的发布时间
        Calendar releaseTime = Calendar.getInstance();
        releaseTime.setTime(vo.getAddTime());
        if (releaseTime.after(nowDate)) {
            portalImageService.insert(pi);
            try {
                //新增定时job
                timeUpBanner(imageId);
            } catch (Exception e) {
                e.printStackTrace();
            }

        } else {
            pi.setState(SiteConstant.FIRST);
            portalImageService.insert(pi);
        }
        return imageId;
    }


    @Override
    public List<PortalBannerVo> viewMessage(Long id) {
        return portalBannerMapper.viewMessage(id);
    }


    @Override
    public Boolean bannerDelete(Long imageId) {
        portalImageMapper.deleteById(imageId);
        return true;
    }


    @Override
    public Boolean bannerUp(Long id) {
        PortalImage portalImage = portalImageService.selectById(id);
        if (portalImage == null) {
            return false;
        }
        portalImage.setState(SiteConstant.FIRST);
        return portalImageMapper.updateById(portalImage) > 0;
    }


    @Override
    public Boolean bannerDown(Long id) {
        PortalImage portalImage = portalImageService.selectById(id);
        if (portalImage == null) {
            return false;
        }
        portalImage.setState(SiteConstant.TWO);
        return portalImageMapper.updateById(portalImage) > 0;
    }

    @Override
    public List<ImageListVO> listAllHomeBannerImage(AllHomeBannerImageVO vo) {
        List<ImageListVO> list = portalBannerMapper.listAllHomeBannerImage(vo);
        for (ImageListVO imageVo : list) {
            imageVo.setKind(SiteEnum.DETAIL.getValue());

            String type;
            if (imageVo.getBannerName().contains("项目")) {
                  type = "train";
            } else {
                type = SiteEnum.getValueByKey(imageVo.getBannerName());
            }
            imageVo.setType(type);
            if (imageVo.getBannerName().equals(SiteEnum.NEWS.getKey())) {
                Information selectById = informationService.selectById(imageVo.getLinkUrl());
                if (selectById != null) {
                    imageVo.setNewsType(selectById.getTypeOne());
                }
            }
        }
        return list;
    }

    @Override
    public List<ImageListVO> selectBanner(ImageListVO imageListVO) {
        String bannerName = imageListVO.getBannerName();
        String terminalName = imageListVO.getTerminalName();
        return portalBannerMapper.selectBanner(bannerName, terminalName);
    }

    @Override
    public Boolean dragImage(IdTwoVO vo) {
        Long accountId = vo.getAccountId();
        String accountName = vo.getAccountName();
        Date date = new Date();
        PortalImage source = portalImageService.selectById(vo.getSourceId());
        PortalImage target = portalImageService.selectById(vo.getTargetId());

        Integer sourceSort = source.getSort();
        Integer targetSort = target.getSort();

        List<PortalImage> portalImageList = portalImageService.getPortalImageList(source.getBannerId(), sourceSort, targetSort);

        log.info("获取的导航的个数：" + portalImageList.size());
        log.info("操作前的列表：" + portalImageList);
        List<PortalImage> portalImgList = new ArrayList<PortalImage>();
        for (PortalImage portalImage : portalImageList) {

            if (targetSort > sourceSort) {
                if (portalImage.getId().equals(source.getId())) {
                    portalImage.setSort(targetSort);
                } else {
                    portalImage.setSort(portalImage.getSort() - 1);
                }

            } else {
                if (portalImage.getId().equals(source.getId())) {
                    portalImage.setSort(targetSort);
                } else {
                    portalImage.setSort(portalImage.getSort() + 1);
                }
            }
            portalImgList.add(portalImage);
        }
        log.info("操作后的列表：" + portalImgList);
        // 批量修改顺序
        if (CollectionUtils.isNotEmpty(portalImgList)) {
            log.info("执行批量修改.");
            portalImageService.updateBatchById(portalImgList);
        }
        return true;
    }

    public void createPortalHome(Long terminalId, Long createById, String createByName, Date date) {
        PortalHome ph = new PortalHome();
        ph.setId(idGenerator.generate());
        ph.setTerminalId(terminalId);
        ph.setState(SiteConstant.FIRST);
        ph.setCreateById(createById);
        ph.setCreateByName(createByName);
        ph.setCreateTime(date);
        portalHomeService.insert(ph);
    }

    
    
    
    /**
     * ---------------------------------------------分隔符------------------------------
     */
	@Override
	public Page<ImageListVO> getAllBanerPc(Long terminalId, Integer pageNo, Integer pageSize) {
		// TODO Auto-generated method stub
		Page<ImageListVO> pageImageListVO=new Page<ImageListVO>();
		Page<ImageListVO> page=new Page<ImageListVO>(pageNo,pageSize);
		List<Long> listIds=portalImageMapper.getIds(terminalId);
		List<ImageListVO>listPortalImage=portalImageMapper.getAllBanerPcByBannerIdPC(terminalId,listIds,page);
		if(page!=null) {
			pageImageListVO.setRecords(listPortalImage);
			pageImageListVO.setTotal(page.getTotal());
		}
		return pageImageListVO;
	}
	
	/**
	 * 创建站点积分配置
	 */
	private void createSitePoint(Long siteId, Long companyId, Long createById, String createByName, Long orgId) {
        PointVo point = new PointVo();
		point.setCompanyId(companyId);
		point.setSiteId(siteId);
		point.setOrgId(orgId);
		point.setState(1);
		point.setUpdateById(createById);
		point.setUpdateByName(createByName);
		point.setUnit("积分"); 
		pointFeignClients.updateList(point); 
    }
}
