package com.yizhi.site.application.service.impl;

import com.yizhi.site.application.domain.PortalHome;
import com.yizhi.site.application.mapper.PortalHomeMapper;
import com.yizhi.site.application.service.HomeAnnouncementService;
import com.yizhi.site.application.service.HomeImageService;
import com.yizhi.site.application.service.HomeLogoService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.site.application.service.PortalHomeService;
import com.yizhi.site.application.service.PortalNavigateService;
import com.yizhi.site.application.service.PortalTemplateService;
import com.yizhi.site.application.service.ProtalContactService;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@Service
@Transactional
public class PortalHomeServiceImpl extends ServiceImpl<PortalHomeMapper, PortalHome> implements PortalHomeService {
	
	@Autowired
	private IdGenerator idGenerator;
	@Autowired
	private PortalNavigateService portalNavigateService;
	@Autowired
	private PortalTemplateService portalTemplateService;
	@Autowired
	private ProtalContactService protalContactService;
	@Autowired
	private HomeImageService homeImageService;
	@Autowired
	private HomeLogoService homeLogoService;
	@Autowired
	private HomeAnnouncementService homeAnnouncementService;
	@Autowired
	private PortalHomeMapper portalHomeMapper;

	@Override
	public boolean copyHome(PortalHome home) {
		Long sourceId = home.getId();
		Long targetId = idGenerator.generate();
		PortalHome ph = new PortalHome();
		BeanUtils.copyProperties(home, ph);
		ph.setId(targetId);
		this.insert(ph);
		//复制首页logo
		homeLogoService.copyHomeLogo(sourceId, targetId);
		//复制导航栏
		portalNavigateService.copyNavigate(sourceId, targetId);
		//复制轮播图
		homeImageService.copyHomeImage(sourceId, targetId);
		//复制公告
		homeAnnouncementService.copyAnnouncement(sourceId, targetId);
		//复制正文模板
		portalTemplateService.copyTemplate(sourceId, targetId);
		//复制联系我们
		protalContactService.copyContact(sourceId, targetId);
		return true;
	}

	@Override
	public Long getHomeId(Long terminalId) {
		// TODO Auto-generated method stub
		PortalHome portalHome=new PortalHome();
		portalHome.setTerminalId(terminalId);
		portalHome=portalHomeMapper.selectOne(portalHome);
		if(portalHome!=null) {
			return portalHome.getId();
		}
		else {
			return null;
		}
	}



}
