package com.yizhi.site.application.service.impl;

import java.util.List;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.site.application.domain.PortalImage;
import com.yizhi.site.application.mapper.PortalImageMapper;
import com.yizhi.site.application.mapper.PortalTerminalMapper;
import com.yizhi.site.application.constant.SiteConstant;
import com.yizhi.application.orm.util.QueryUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.site.application.service.PortalImageService;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@Service
public class PortalImageServiceImpl extends ServiceImpl<PortalImageMapper, PortalImage> implements PortalImageService {

	
	@Autowired
	PortalImageMapper  portalImageMapper;
	
	@Autowired 
	private PortalTerminalMapper portalTerminalMapper;
	
	@Override
	public List<PortalImage> getImages(Long siteId) {
		return portalImageMapper.selectImages(siteId);
	}

	@Override
	public Integer countImage(Long bannerId) {
		return portalImageMapper.countImage(bannerId);
	}

    @Override
    public List<PortalImage> getPortalImageList(Long bannerId, Integer sourceSort, Integer targetSort) {

        PortalImage portalImage = new PortalImage();
        portalImage.setBannerId(bannerId);
        portalImage.setState(SiteConstant.FIRST);
        EntityWrapper<PortalImage> wrapper = QueryUtil.condition(portalImage);
        if (targetSort<sourceSort) {
            wrapper.where("sort <= {0}",sourceSort).andNew("sort >= {0}",targetSort);
        } else {
            wrapper.where("sort <=  {0}",targetSort).andNew("sort >= {0}",sourceSort);
        }
        wrapper.orderBy("sort",true);
        List<PortalImage> list = this.selectList(wrapper);

        return list;
    }
    
    
    
    
    /**
     * ----------------------------------------分隔符------------------------------------------
     */

	@Override
	public PortalImage getPortalImageById(Long imageId) {
		// TODO Auto-generated method stub
		PortalImage portalImage=new PortalImage();
		portalImage.setId(imageId);
		portalImage.setState(1);
		EntityWrapper<PortalImage> wrapper=new EntityWrapper<PortalImage>(portalImage);
		return this.selectOne(wrapper);
	}

	@Override
	public List<PortalImage> listApiPortalPCPortalImage(Long siteId, Integer terminalType) {
		// TODO Auto-generated method stub
		Long homeId=portalTerminalMapper.geHomeIdByTerminalTypeAndSiteId(siteId, terminalType);
		//前端默认显示五条
		List<PortalImage> listPortalImage=null;
		if(homeId!=null) {
			listPortalImage=portalImageMapper.listPortalImageGetByHomeIdApiPCLimit(homeId);
		}
		return listPortalImage;
	}


}
