package com.yizhi.site.application.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.yizhi.core.application.cache.CacheNamespace;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.site.application.domain.PortalTemplate;
import com.yizhi.site.application.domain.ProtalPlate;
import com.yizhi.site.application.mapper.ProtalPlateMapper;
import com.yizhi.site.application.constant.SiteConstant;
import com.yizhi.site.application.enums.PortalEnum;
import com.yizhi.site.application.enums.SiteEnum;
import com.yizhi.site.application.internationlization.InternationalizationUtil;
import com.yizhi.site.application.service.PortalTemplateService;
import com.yizhi.site.application.service.ProtalPlateService;
import com.yizhi.site.application.vo.domain.ProtalPlateVo;
import com.yizhi.site.application.vo.site.PlateVO;
import com.yizhi.site.application.vo.site.PortalPlateVO;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.site.application.vo.site.TemplateInsertPcVO;
import com.yizhi.system.application.utils.ClassUtils;
import com.yizhi.system.application.vo.InternationalizationVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@Service
public class ProtalPlateServiceImpl extends ServiceImpl<ProtalPlateMapper, ProtalPlate> implements ProtalPlateService {


	@Autowired
	private IdGenerator idGenerator;
	@Autowired
	private PortalTemplateService portalTemplateService;

	@Autowired
	private ProtalPlateMapper protalPlateMapper;
	@Autowired
	private InternationalizationUtil internationalizationUtil;
    @Autowired
    private RedisCache redisCache;



    @Override
	public Boolean templateContentAdd(TemplateInsertPcVO templateInsertPcVO) {

		Long templateId=templateInsertPcVO.getId();
		Integer num=templateInsertPcVO.getNum();
		Integer moduleType=templateInsertPcVO.getModuleType();
		List<ProtalPlateVo> listPlate=templateInsertPcVO.getListPlate();
		Long accountId=ContextHolder.get().getAccountId();
		String accountName=ContextHolder.get().getAccountName();
        Date updateDate=new Date();
		//先更新主体信息
		if(SiteConstant.FIRST.equals(moduleType)||SiteConstant.SEVEN.equals(moduleType)|| SiteConstant.NINE.equals(moduleType)) {
			PortalTemplate portalTemplate=new PortalTemplate();
			portalTemplate.setId(templateId);
			portalTemplate.setNum(num);
			portalTemplate.setModuleName(templateInsertPcVO.getModuleName());
            if (portalTemplateService.updateById(portalTemplate)) {
                InternationalizationVo a = new InternationalizationVo();
                a.setTableType(ClassUtils.getTableName(PortalTemplate.class));
                a.setTaskId(templateId);
                //同时修改国际化对应记录
                a.setName(templateInsertPcVO.getModuleName());
                internationalizationUtil.updateInternationalization(a);
            }
			//更新模板信息
			//先删除已经存在的模板信息--然后删除内容信息逻辑删除
			protalPlateMapper.updateStateByTemplateId(templateId, accountId, accountName, updateDate);
		}
		ProtalPlate protalPlate=null;
		if(CollectionUtils.isNotEmpty(listPlate)) {
			Integer maxSort=protalPlateMapper.maxSort(templateId);
			if(maxSort==null) {
				maxSort=0;
			}
			for (int i = 0; i < listPlate.size(); i++) {
                ProtalPlateVo plate = listPlate.get(i);
                // 判断是否重复添加
                ProtalPlate query=new ProtalPlate();
                query.setLinkContent(plate.getLinkContent());
                query.setTemplateId(templateId);
                query.setState(1);//未删除
                EntityWrapper en = new EntityWrapper(query);
                int existCount = this.selectCount(en);
                if (existCount > 0){
                    continue;
                }
                maxSort++;
				protalPlate=new ProtalPlate();

				protalPlate.setId(idGenerator.generate());
				protalPlate.setTemplateId(templateId);
				protalPlate.setLinkContent(plate.getLinkContent() != null?plate.getLinkContent():0L);//精选:活动ID
				protalPlate.setState(1);
				protalPlate.setSort(maxSort);
				protalPlate.setCreateById(accountId);
				protalPlate.setCreateByName(accountName);
				protalPlate.setCreateTime(updateDate);

                protalPlate.setThumbnail(plate.getThumbnail());
                if (null != plate.getThumbnail() && null != plate.getImgPath()) {
                    protalPlate.setImgPath(plate.getThumbnail() == 2 ? plate.getImgPath() : "");
                }
                if(moduleType==1) {
					protalPlate.setLinkType(plate.getLinkType());
					//描述
					protalPlate.setDirections(plate.getDirections());

					if(listPlate.get(i).getLinkType()==13) {
						Long urlId=idGenerator.generate();
						//当外链的时候接这个值  比如 百度，腾讯
						protalPlate.setLinkContentName(plate.getLinkContentName());
						//当外链的时候，外链的地址   这个外链和培训项目的外链不是一个东西  7外联信息保存在培训项目 13 保存在门户
						protalPlate.setSelectActivityName(plate.getSelectActivityName());
						//给外链一个id，方便回显的时候查看
						protalPlate.setSelectActivity(urlId);
						//这两个字段保存一样的值
						protalPlate.setLinkContent(urlId);
					}

				}
				this.insert(protalPlate);
			}
		}
		return true;
	}



	@Override
	public List<ProtalPlate> templateContentView(Long id) {
		// TODO Auto-generated method stub
		ProtalPlate protalPlate=new ProtalPlate();
		protalPlate.setTemplateId(id);
		protalPlate.setState(1);
		EntityWrapper<ProtalPlate> wrapper=new EntityWrapper<ProtalPlate>(protalPlate);
		wrapper.orderBy("sort", true);
		return this.selectList(wrapper);
	}



	@Override
	public Boolean templateContentUpdate(Long id, Long activityId,Integer state,String imgUrl) {
		// TODO Auto-generated method stub
		ProtalPlate protalPlate=new ProtalPlate();
		if(state!=null) {
			protalPlate.setState(state);
		}
		if(imgUrl!=null) {
			protalPlate.setImgPath(imgUrl);
		}
		protalPlate.setUpdateById(ContextHolder.get().getAccountId());
		protalPlate.setUpdateByName(ContextHolder.get().getAccountName());
		protalPlate.setUpdateTime(new Date());
		ProtalPlate protalPlateWhere =new ProtalPlate();
		protalPlateWhere.setTemplateId(id);
		protalPlateWhere.setLinkContent(activityId);
		EntityWrapper<ProtalPlate> wrapper=new EntityWrapper<ProtalPlate>(protalPlateWhere);


		return this.update(protalPlate, wrapper);
	}



	@Override
	public List<Long> templateContentViewByTerminalIdAndModuleType(Long terminalId, Integer moduleType) {
		// TODO Auto-generated method stub
		return protalPlateMapper.templateContentViewByTerminalIdAndModuleType(terminalId, moduleType);
	}



	@Override
	public List<ProtalPlate> templateContentViewApi(Long id) {
		// TODO Auto-generated method stub
		ProtalPlate protalPlate=new ProtalPlate();
		protalPlate.setTemplateId(id);
		protalPlate.setState(1);
		EntityWrapper<ProtalPlate> wrapper=new EntityWrapper<ProtalPlate>(protalPlate);
		wrapper.orderBy("sort", true);
		return this.selectList(wrapper);
	}

    @Override
    public List<PortalPlateVO> getPlateVOList(Long templateId) {
        return this.baseMapper.getPlateVOList(templateId);
    }

    @Override
    public List<ProtalPlate> getPlateListById(Long id) {
        return this.baseMapper.getPlateListById(id);
    }

    @Override
    public boolean sortPlate(Long id, String code) {

        List<ProtalPlate> protalPlateList = this.getPlateListById(id);

        if (code.equals(SiteEnum.UP.getKey())){
            if (id.equals(protalPlateList.get(0).getId())){
                return false;
            }
            List<ProtalPlate> ppList = new ArrayList<>();
            ProtalPlate plate = new ProtalPlate();
            int sort =0;
            for (int i=protalPlateList.size();i>=1;i--){
                plate = protalPlateList.get(i-1);
                if (plate.getId().equals(id)){
                    sort = plate.getSort();
                    plate.setSort(i-1);
                } else {
                    if (sort!=0) {
                        plate.setSort(i+1);
                        sort =0;
                    } else {
                        plate.setSort(i);
                    }
                }
                ppList.add(plate);
                }
                this.updateBatchById(ppList);

        } if (code.equals(SiteEnum.DOWN.getKey())){
            if (id.equals(protalPlateList.get(protalPlateList.size()-1).getId())){
                return false;
            }
            List<ProtalPlate> ppList = new ArrayList<>();
            ProtalPlate plate = new ProtalPlate();
            int sort =0;
            for (int i=1;i<=protalPlateList.size();i++){
                plate = protalPlateList.get(i-1);
                if (plate.getId().equals(id)){
                    sort = plate.getSort();
                    plate.setSort(i+1);
                } else {
                    if (sort!=0) {
                        plate.setSort(i-1);
                        sort =0;
                    } else {
                        plate.setSort(i);
                    }
                }
                ppList.add(plate);
            }
            this.updateBatchById(ppList);
        }
        redisCache.delete(CacheNamespace.SITE_STUDENT_RECORDS + ContextHolder.get().getSiteId() + "_" + protalPlateList.get(0).getTemplateId());
        return true;
    }

    @Override
    public List<ProtalPlate> getIdsByTemplateId(Long tempateId) {
        ProtalPlate protalPlate = new ProtalPlate();
        protalPlate.setTemplateId(tempateId);
        protalPlate.setState(PortalEnum.ONE.ordinal());

        return this.selectList(QueryUtil.condition(protalPlate));
    }

    @Override
    public boolean updatePlate(PlateVO plateVO) {
        ProtalPlate protalPlate = new ProtalPlate();
        BeanUtils.copyProperties(plateVO,protalPlate);
        ProtalPlate protalPlate1 = this.selectById(protalPlate.getId());
        if (protalPlate1 == null){
            return false;
        }
        redisCache.delete(CacheNamespace.SITE_STUDENT_RECORDS + ContextHolder.get().getSiteId() + "_" + protalPlate1.getTemplateId());
        return this.updateById(protalPlate);
    }

    @Override
    public ProtalPlate getPlate(ProtalPlate protalPlate) {

        return this.selectOne(QueryUtil.condition(protalPlate));
    }

    @Override
    public List<Long> selectHomeConfigList(String terminalName, Long siteId, int moduleType) {
        return this.baseMapper.selectHomeConfigList(terminalName,siteId,moduleType) ;
    }



	@Override
	public ProtalPlate getUrl(Long selectActivityId) {
		ProtalPlate pp=new ProtalPlate();
		pp.setSelectActivity(selectActivityId);
		EntityWrapper<ProtalPlate> wrapper=new EntityWrapper<ProtalPlate>(pp);
		// TODO Auto-generated method stub
		return this.selectOne(wrapper);
	}

    @Override
    public List<ProtalPlate> getPlateListById(List<Long> ids) {
        ProtalPlate pp=new ProtalPlate();
        pp.setState(SiteConstant.FIRST);
        EntityWrapper<ProtalPlate> wrapper=new EntityWrapper<ProtalPlate>(pp);
        wrapper.in("link_content",ids);
        return this.selectList(wrapper);
    }

    /**
     * 修改模块并回调
     * @param plateVO
     * @return
     */
    @Override
    public ProtalPlateVo updateBackPlate(PlateVO plateVO) {
        ProtalPlateVo vo = new ProtalPlateVo();
        ProtalPlate protalPlate = new ProtalPlate();
        BeanUtils.copyProperties(plateVO,protalPlate);
        ProtalPlate protalPlate1 = this.selectById(protalPlate.getId());
        if (protalPlate1 != null){
            if (this.updateById(protalPlate)) {
                BeanUtils.copyProperties(selectById(protalPlate.getId()), vo);
                return vo;
            }
        }
        return null;
    }

}
