package com.yizhi.site.application.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.site.application.domain.RelationLive;
import com.yizhi.site.application.mapper.RelationLiveMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.site.application.service.IRelationLiveService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author fulan123
 * @since 2018-12-17
 */
@Service
public class RelationLiveServiceImpl extends ServiceImpl<RelationLiveMapper, RelationLive> implements IRelationLiveService {

    @Autowired
    private IdGenerator idGenerator;

    @Autowired
    private RelationLiveMapper relationLiveMapper;

    @Override
    public RelationLive saveRelationLive(Long terminalId, Long liveId) {
        // TODO Auto-generated method stub
        RelationLive relationLive1 = new RelationLive();
        relationLive1.setState(0);
        relationLive1.setUpdateById(ContextHolder.get().getAccountId());
        relationLive1.setUpdateByName(ContextHolder.get().getAccountName());
        relationLive1.setUpdateTime(new Date());


        RelationLive relationLive2 = new RelationLive();
        relationLive2.setTerminalId(terminalId);
        EntityWrapper<RelationLive> wrapper = new EntityWrapper<RelationLive>(relationLive2);
        this.update(relationLive1, wrapper);


        Date time = new Date();
        RelationLive relationLive = new RelationLive();
        Boolean isTrue = false;

        relationLive.setId(idGenerator.generate());
        relationLive.setTerminalId(terminalId);
        relationLive.setLiveId(liveId);
        relationLive.setState(1);
        relationLive.setCreateById(ContextHolder.get().getAccountId());
        relationLive.setCreateByName(ContextHolder.get().getAccountName());
        relationLive.setCreateTime(time);
        isTrue = this.insert(relationLive);


        if (isTrue) {
            return relationLive;
        }
        return new RelationLive();
    }

    @Override
    public List<Long> getRelationLivePc(Long terminalId) {
        // TODO Auto-generated method stub
        RelationLive relationLive = new RelationLive();
        relationLive.setTerminalId(terminalId);
        relationLive.setState(1);
        EntityWrapper<RelationLive> wrapper = new EntityWrapper<RelationLive>(relationLive);
        List<RelationLive> listRelationLive = this.selectList(wrapper);
        List<Long> listIds = null;
        if (CollectionUtils.isNotEmpty(listRelationLive)) {
            listIds = new ArrayList<Long>();
            for (int i = 0; i < listRelationLive.size(); i++) {
                listIds.add(listRelationLive.get(i).getLiveId());
            }
        }
        return listIds;
    }

    @Override
    public Boolean deleteRelationLive(Long terminalId, Long liveId) {
        // TODO Auto-generated method stub
        RelationLive relationLive1 = new RelationLive();
        relationLive1.setState(0);
        relationLive1.setUpdateById(ContextHolder.get().getAccountId());
        relationLive1.setUpdateByName(ContextHolder.get().getAccountName());
        relationLive1.setUpdateTime(new Date());

        RelationLive relationLive = new RelationLive();
        relationLive.setTerminalId(terminalId);
        relationLive.setLiveId(liveId);
        EntityWrapper<RelationLive> wrapper = new EntityWrapper<RelationLive>(relationLive);
        return this.update(relationLive1, wrapper);
    }

    @Override
    public Long getRelationLive(Long siteId, Integer terminalType) {
        // TODO Auto-generated method stub
        return relationLiveMapper.getRelationLive(siteId, terminalType);
    }
    
    @Override
    public List<RelationLive> getRelationLiveList(Long siteId, Long liveId) {
        List<RelationLive> relationLiveList = this.baseMapper.getRelationLiveList(liveId, siteId);
        return relationLiveList;
    }

}
