package com.yizhi.site.application.feign;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.site.application.vo.domain.*;
import com.yizhi.site.application.vo.site.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name = "portal", contextId = "PortalManagePCFeignClients")
public interface PortalManagePCFeignClients {
	
	
	@GetMapping("/manage/portal/pc/test/myself")
	List<PortalNavigateVo> testMyself(@RequestParam("id3")Long id2);
	
	
	
	
	/**
	 * pc首页logo新增--完毕
	 * @param vo
	 * @return
	 */
	@GetMapping("/manage/portal/pc/home/logo/insert")
    HomeLogoVO insertHomeLogoPc(@RequestParam(value="terminalId",required=true)Long terminalId, @RequestParam(value="logoPath",required=true)String logoPath);
	
	/**
	 * 首页logo删除
	 * @param logoId
	 * @return
	 */
	@GetMapping("/manage/portal/pc/home/logo/delete")
	Boolean deleteHomeLogoPc(@RequestParam("logoId")Long logoId);
	
	/**
	 * 首页logo修改--完毕
	 * @param vo
	 * @return
	 */
	@GetMapping("/manage/portal/pc/home/logo/update")
	HomeLogoVO updateHomeLogoPc(@RequestParam(value="logoId",required=true)Long logoId,@RequestParam(value="newLogoPath",required=true)String newLogoPath);
	
	
	
	/**
	 * 首页logo查看----完毕
	 * @param homeId
	 * @return
	 */
	@GetMapping("/manage/portal/pc/home/logo/view")
	HomeLogoVO viewHomeLogoPc(@RequestParam("terminalId")Long terminalId);
	
	
	/**
	 * 功能关联列表
	 */
	@GetMapping("/manage/portal/pc/home/alllistLink")
	List<RelationLinkVo> getAllListLink(@RequestParam(value="name",required=false)String name, @RequestParam(value="type",required=true)Integer type);
	
	
	
	/**
	 * 头部导航栏功能入口修改/新增
	 * @param vo
	 * @return
	 */
	@PostMapping("/manage/portal/pc/home/navigate/update")
    PortalNavigateVo updateAndInsertNavigatePc(@RequestBody NavigateListVO vo);
	
	
	
	/**
	 * 已经关联的链接
	 * @param terminalId
	 * @param pcType
	 * @return
	 */
	@GetMapping("/manage/portal/pc/home/navigate/select")
	List<PortalNavigateVo> getRelationListLink(@RequestParam(name = "terminalId", required = true) Long terminalId, @RequestParam(name = "pcType", required = true) Integer pcType);
	
	/**
	 * 删除链接
	 * @param id
	 * @return
	 */
	@GetMapping("/manage/portal/pc/home/navigate/delete")
	Boolean deleteNavigatePc(@RequestParam(name = "id", required = true) Long id);
	
	
	@GetMapping("/manage/portal/pc/home/navigate/update/sort")
	Boolean updateSortNavigatePc(@RequestParam(name = "id", required = true) Long id,@RequestParam(name = "isDown", required = true) Integer isDown);
	
	
	/**
	 * 首页pc端查看访问人数
	 * @param terminalId
	 * @return
	 */
	@GetMapping("/manage/portal/pc/home/look/num/select")
    TrPortalLookNumVo lookNumSelectPc(@RequestParam(name = "terminalId", required = true) Long terminalId);
	
	
	/**
	 * 设置访问人数
	 * @param trPortalLookNumEntityVo
	 * @return
	 */
	@GetMapping("/manage/portal/pc/home/look/num/set")
	TrPortalLookNumVo lookNumSetPc(@RequestBody TrPortalLookNumVo trPortalLookNumEntityVo);
	
	/**
	 * 已关联的轮播图
	 * @param terminalId
	 * @return
	 */
	@GetMapping("/manage/portal/pc/home/banner/select")
	List<PreviewImageVO> getRelationBanerPc(@RequestParam(name = "terminalId", required = true) Long terminalId);
	
	

	/**
	 * 全部轮播图
	 * @param pageNo
	 * @param pageSize
	 * @return
	 */
	@GetMapping("/manage/portal/pc/home/banner/all")
	Page<ImageListVO> getAllBanerPc(@RequestParam(name = "terminalId", required = true) Long terminalId,
                                    @RequestParam("pageNo")Integer pageNo,
                                    @RequestParam("pageSize")Integer pageSize);
	
	@GetMapping("/manage/portal/pc/banner/insert")
	Boolean insertBanerPc( @RequestParam(name = "terminalId", required = true) Long terminalId,
			                                   @RequestParam(name = "ids", required = true) List<Long> ids);

	/**
	 * 删除轮播图
	 * @param id
	 * @return
	 */
	@GetMapping("/manage/portal/pc/home/banner/delete")
	Boolean deleteRelationBanerPc(@RequestParam(name = "terminalId") Long terminalId,@RequestParam("id")Long id);
	
	
	@GetMapping("/manage/portal/pc/home/banner/update/sort")
	Boolean updateBannerSortPC(@RequestParam(name = "terminalId", required = true) Long terminalId,@RequestParam(name = "currentId", required = true) Long currentId,@RequestParam(name = "isDown", required = true) Integer isDown);
	
	
	
	@GetMapping("/manage/portal/pc/live/relation")
	List<Long> getRelationLivePc(@RequestParam(name = "terminalId", required = true) Long terminalId);
	
	/**
	 * 保存直播信息
	 * @param id
	 * @param terminalId
	 * @param liveId
	 * @return
	 */
	@GetMapping("/manage/portal/pc/home/live/save")
    RelationLiveVo saveRelationLive(@RequestParam(name = "terminalId", required = true) Long terminalId, @RequestParam(name = "liveId", required = true) Long liveId);
	
	
	@GetMapping("/manage/portal/pc/home/live/delete")
	Boolean deleteRelationLive(@RequestParam(name = "terminalId", required = true) Long terminalId,@RequestParam(name = "liveId", required = true) Long liveId);
	/**
	 * 导航栏2是否显示
	 * @param id
	 * @param display
	 * @return
	 */
	@GetMapping("/manage/portal/pc/navigate/update/display")
	Boolean navigateUpdateDisplay(@RequestParam(name = "terminalId", required = true) Long terminalId,@RequestParam(name = "display", required = true) Integer display);
	
	
	
	@GetMapping("/manage/portal/pc/navigate/view/display")
	Integer navigateViewDisplay(@RequestParam(name = "terminalId", required = true) Long terminalId);
	
	
	/**
	 * 查看所有公告
	 * @param pageNo
	 * @param pageSize
	 * @return
	 */
	@GetMapping("/manage/portal/pc/announcement/all")
	Page<InformationVo> getAllAnnouncementPC(
			@RequestParam(name = "terminalId", required = true) Long terminalId,
			@RequestParam(name = "pageNo", required = false,defaultValue="1") Integer pageNo,
			@RequestParam(name = "pageSize", required = false,defaultValue="10") Integer pageSize);
	
	
	/**
	 * 已经关联的公告
	 * @param terminalId
	 * @return
	 */
	@GetMapping("/manage/portal/pc/announcement/select")
	List<InformationVo> getRelationAnnouncement(@RequestParam(name = "terminalId", required = true) Long terminalId);
	
	
	/**
	 *终端添加公告/模块状态是否显示
	 * @param announcementVO
	 * @return
	 */
	@PostMapping("/manage/portal/pc/announcement/insert/update")
	Boolean insertUpdateRelationAnnouncementPC(@RequestBody AnnouncementVO announcementVO);
	
	
	/**
	 * 公告查看是否显示
	 * @param terminalId
	 * @return
	 */
	@GetMapping("/manage/portal/pc/announcement/view/display")
	Integer  announcementViewDisplay(@RequestParam(name = "terminalId", required = true) Long terminalId);
	
	/**
	 * 公告id更换排序规则
	 * @param sourceId
	 * @param targetId
	 * @return
	 */
	@GetMapping("/manage/portal/pc/announcement/details/update")
	Boolean updateDetailsAnnouncementPC(@RequestParam(name = "terminalId", required = true) Long terminalId,@RequestParam(name = "currentId", required = true) Long currentId,@RequestParam(name = "isDown", required = true) Integer isDown);
	
	
	
	
	/**
	 * 模板list
	 * @param terminalId
	 * @return
	 */
	@GetMapping("/manage/portal/pc/module/list/select")
	List<PortalTemplateVo> moduleListSelect(@RequestParam(name = "terminalId", required = true) Long terminalId);
	
	
	/**
	 * 添加模块名字
	 * @param terminalId
	 * @param moduleType
	 * @param moduleName
	 * @return
	 */
	@GetMapping("/manage/portal/pc/module/name/add")
	PortalTemplateVO moduleNameAdd(@RequestParam(name = "terminalId", required = true) Long terminalId, @RequestParam(name = "currentId", required = false) Long currentId, @RequestParam(name = "isDown", required = false) Integer isDown, @RequestParam(name = "moduleType", required = true) Integer moduleType, @RequestParam(name = "moduleName", required = true) String moduleName);
	
	
	
	/**
	 * 更改模板基本信息
	 * @param id
	 * @param name
	 * @param state
	 * @return
	 */
	@GetMapping("/manage/portal/pc/module/update/message")
	Boolean moduleUpdateMessage(@RequestParam(name = "id", required = true) Long id,@RequestParam(name = "name", required = false) String name,@RequestParam(name = "state", required = false) Integer state,@RequestParam(name = "display", required = false) Integer display,@RequestParam(name = "isDown", required = false) Integer isDown);
	
	
	/**
	 * 更改排序规则
	 * @param sourceId
	 * @param targetId
	 * @return
	 *//*
	@GetMapping("/manage/portal/pc/module/update/sort")
	Boolean moduleUpdateSort(@RequestParam(name = "sourceId", required = true) Long sourceId,@RequestParam(name = "targetId", required = true) Long targetId);*/
	
	
	/**
	 * 精品推荐添加
	 * @param templateInsertPcVO
	 * @return
	 */
	@PostMapping("/manage/portal/pc/template/content/add")
	Boolean templateContentAdd(@RequestBody TemplateInsertPcVO templateInsertPcVO);
	
	
	/**
	 * 模板内容展示
	 * @param id
	 * @return
	 */
	@GetMapping("/manage/portal/pc/template/content/view")
	List<ProtalPlateVo> templateContentView(@RequestParam(name = "id", required = true) Long id);
	
	
	
	@GetMapping("/manage/portal/pc/template/content/view/byterminalId/and/moduleType")
	List<Long> templateContentViewByTerminalIdAndModuleType(@RequestParam(name = "terminalId", required = true) Long terminalId,@RequestParam(name = "moduleType", required = true) Integer moduleType);
	
	/**
	 * 删除活动
	 * @param id
	 * @param activityId
	 * @return
	 */
	@GetMapping("/manage/portal/pc/template/content/update")
	Boolean templateContentUpdate(@RequestParam(name = "id", required = true) Long id,@RequestParam(name = "activityId", required = true) Long activityId,@RequestParam(name = "state", required = false) Integer state,@RequestParam(name = "imgUrl", required = false) String imgUrl);
	
	/**
	 * 回显列表
	 */
	@GetMapping("/manage/portal/pc/template/content/select/content/view")
	PortalTemplateTraining templateContentSelectContentView(@RequestParam(name = "id", required = true) Long id);
	
	
	/**
	 * 得到所有公告
	 * @return
	 */
	@GetMapping("/manage/portal/pc/news/get/all")
	Page<InformationViewVO> newsGetAll(
			@RequestParam(value="terminalId",required=true)Long terminalId,
			@RequestParam("pageNo")Integer pageNo,
                                                               @RequestParam("pageSize")Integer pageSize);
	
	
	
	@GetMapping("/manage/portal/pc/news/get/relation")
	List<InformationViewVO> getRelationInformation(@RequestParam(name = "id", required = true) Long id);
	
	
	
	@PostMapping("/manage/portal/pc/page/save/message")
	Boolean pageBottomSave(@RequestBody TrPortalPagePCVo trPortalPagePCVo);
	
	
	@GetMapping("/manage/portal/pc/page/bottom/view")
	TrPortalPageVo pageBottomView(@RequestParam(name = "terminalId", required = true) Long terminalId) ;
	
	@GetMapping("/manage/portal/pc/page/bottom/update")
	Boolean pageBottomUpdate(@RequestParam(name = "pageId", required = true) Long pageId,@RequestParam(name = "type", required = true) Integer type);
	
	@GetMapping("/manage/portal/pc/page/bottom/delete")
	Boolean pageBottomDelete(@RequestParam(name = "id", required = true) Long id);
	
	
	@GetMapping("/manage/portal/pc/page/bottom/update/sort")
	Boolean pageBottomUpdateSort(@RequestParam(name = "id", required = true) Long id,@RequestParam(name = "isDown", required = true) Integer isDown);
	
	
	@GetMapping("/manage/portal/pc/site/url")
	ProtalPlateVo getUrl(@RequestParam(name="selectActivityId",required=true)Long selectActivityId);
	
	/**
	
	
	*//**
	 * 模块新增
	 * @param vo
	 * @return  返回模块ID
	 *//*
	Long insertTemplate(@RequestBody TemplateAddVO vo);
	
	
	
	
	
	*//**
	 * 在当前模块上方或者下方进行插入
	 * @param vo
	 * @return  插入新模块的模板I
	 *//*
	Long insertTemplateByCurrent(@RequestBody TemplateAddVO vo);
	
	
	

	*//**
	 * 模块删除
	 * 重命名模块
	 * 是否显示模块
	 * @param portalTerminal
	 * @return
	 *//*
	Long  renameTemplate(@RequestBody PortalTerminalEntityVo portalTerminal);
	
	
	

	
	*//**
	 * 模块上移下移
	 * @param vo
	 * @return
	 *//*
	Boolean dragTemplateSort(@RequestBody IdTwoVO vo);
	
	
	*//**
	 * 模块查看
	 * @param templateId
	 * @return
	 *//*
	TemplateListVO viewTemplate(@RequestParam(value="templateId",required=true)Long templateId);
	
	
	*//**
	 * 模块栏目修改
	 * @param vo
	 * @return
	 *//*
	Boolean updateTemplate(@RequestBody TemplateUpdateVO vo);
	
	
	
	
	*//**
	 * 添加页底
	 * @param vo
	 * @return
	 *//*
	Boolean insertPageBottom(@RequestBody TrPortalPageBottomVO vo);
	
	
	
	*//**
	 * 预览页底
	 * @param homeId
	 * @param terminalId
	 * @return
	 *//*
	TrPortalPageBottomVO selectPageBottom(@RequestParam(value="homeId",required=true)Long homeId,
			                                                                      @RequestParam(value="terminalId",required=true)Long terminalId);
	
	
	
	*//**
	 * 更改页底排序规则
	 * @param vo
	 * @return
	 *//*
	Boolean dragPageBottomSort(@RequestBody IdTwoVO vo);*/


	/**
	 * 修改模块并回调
	 * @param plateVO
	 * @return
	 */
	@PostMapping("/manage/portal/pc/plate/back/update")
	ProtalPlateVo updateBackPlate(@RequestBody PlateVO plateVO);

	/**
	 * 修改模块
	 * @param plateVO
	 * @return
	 */
	@PostMapping("/manage/portal/pc/plate/update")
	Boolean updatePlate(@RequestBody PlateVO plateVO);

    /**
     * 获取plate
     * @param protalPlate
     * @return
     */
    @GetMapping("/manage/portal/pc/plate/get")
	ProtalPlateVo getPlate(@RequestBody ProtalPlateVo protalPlate);

	@PostMapping("/manage/portal/pc/plate/get")
	ProtalPlateVo getPlateBy(@RequestBody ProtalPlateVo protalPlate);

    /**
     * 获取关联的内容
     * @param ids
     * @return
     */
    @PostMapping(value = "/manage/portal/pc/get/plate/list")
    List<ProtalPlateVo> getPlateListById(@RequestBody List<Long> ids);


    @GetMapping("/manage/portal/pc/relation/live/list")
    List<RelationLiveVo> getRelationLive(@RequestParam(name = "siteId", required = true) Long siteId,
											   @RequestParam(name = "liveId", required = true) Long liveId);
}


