package com.yizhi.site.application.vo.domain;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value = "InformationClassify", description = "资讯分类")
@Data
@TableName("information_classify")
public class InformationClassify extends Model<InformationClassify> {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "主鍵")
	private Long id;

	@ApiModelProperty(value = "资讯ID")
	@TableField("information_id")
	private Long informationId;

	@ApiModelProperty(value = "文章父类型")
	@TableField("type_one")
	private Long typeOne;
	
	@ApiModelProperty(value = "文章父类型名称")
	@TableField(exist = false)
	private String typeOneName;

	@ApiModelProperty(value = "文章子类型（二级）")
	@TableField("type_two")
	private Long typeTwo;
	
	@ApiModelProperty(value = "文章子类型（二级）名称")
	@TableField(exist = false)
	private String typeTwoName;

	@ApiModelProperty(value = "文章子类型（三级）")
	@TableField("type_three")
	private Long typeThree;
	
	@ApiModelProperty(value = "文章子类型（三级）名称")
	@TableField(exist = false)
	private String typeThreeName;
	
	@ApiModelProperty(value = "创建时间")
	@TableField("create_time")
	private Date createTime;
	
	@ApiModelProperty(value = "创建人")
	@TableField("create_by_id")
	private Long createById;

	@ApiModelProperty(value = "创建人姓名")
	@TableField("create_by_name")
	private String createByName;

	@ApiModelProperty(value = "修改时间")
	@TableField("update_time")
	private Date updateTime;

	@ApiModelProperty(value = "修改人")
	@TableField("update_by_id")
	private Long updateById;

	@ApiModelProperty(value = "修改人姓名")
	@TableField("update_by_name")
	private String updateByName;
	
	@Override
	protected Serializable pkVal() {
		return this.id;
	}
}