package com.yizhi.site.application.vo.domain;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@ApiModel(value = "PortalTerminalEntityVo", description = "终端")
@Data
public class PortalTerminalVo  {

    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty(value = "主键")
    private Long id;
    
    @ApiModelProperty(value = "站点ID")
    private Long siteId;
    
    @ApiModelProperty(value = "应用名称")
    private String terminalName;
    
    @ApiModelProperty(value = "终端类型:1-PC 2-APP 3-微信")
    private Integer type;
    
    @ApiModelProperty(value = "0未发布 1已生效（已发布）")
    private Integer state;
    
    @ApiModelProperty(value = "0不显示 1显示")
    private Integer display;
    
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    
    @ApiModelProperty(value = "创建人")
    private Long createById;
    
    @ApiModelProperty(value = "创建人姓名")
    private String createByName;
    
    @ApiModelProperty(value = "修改时间")
    private Date updateTime;
    
    @ApiModelProperty(value = "修改人")
    private Long updateById;
    
    @ApiModelProperty(value = "修改人姓名")
    private String updateByName;
    
    @ApiModelProperty(value = "公司ID")
    private Long companyId;
    
    @ApiModelProperty(value = "部门ID")
    private Long orgId;


    protected Serializable pkVal() {
        return this.id;
    }
}
