package com.yizhi.site.application.vo.site;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@ApiModel(value = "NavigateListVO", description = "头部导航栏")
@Data
public class NavigateListVO extends KindAndTypeVO {


    @ApiModelProperty(value = "terminalId")
    private Long terminalId;


    @ApiModelProperty(value = "导航栏ID主键")
    private Long id;

    @ApiModelProperty(value = "首页ID")
    private Long homeId;

    @ApiModelProperty(value = "站点ID")
    private Long siteId;

    @ApiModelProperty(value = "显示名称, 栏目名称")
    private String showName;

    @ApiModelProperty(value = "图片路径")
    private String imgPath;

    @ApiModelProperty(value = "关联功能类型,  自定义的为 1，  系统提供的为0")
    private Integer relationFunc;

    @ApiModelProperty(value = "关联功能名称")
    private String relationFuncName;

    @ApiModelProperty(value = "关联功能编码")
    private String relationFuncCode;

    @ApiModelProperty(value = "pc端关联功能链接, 移动端 请求跳转后的id")
    private String relationFuncUrl;

    @ApiModelProperty(value = "显示状态, 0 不显示  1 显示")
    private Integer display;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "排序")
    private Integer sort;

    @ApiModelProperty(value = "0: 删除  1:未发布  2：发布")
    private Integer state;

    @ApiModelProperty(value = "账号")
    private Long accountId;

    @ApiModelProperty(value = "姓名")
    private String accountName;

    @ApiModelProperty(value = "栏目名称")
    private String catname;

    @ApiModelProperty(value = "关联的id，如课程分类id")
    private Long relationId;

    @ApiModelProperty(value = "关联的课程分类")
    private String classifyName;

    /**
     * 王飞达
     */

    @ApiModelProperty(value = "满足pc端加的字段 type=1 上边的导航栏   2  下边的导航栏（只适合pc端）")
    private Integer pcType;


    @ApiModelProperty(value = "关联数量1 学习时长排行榜,2 案例排行榜")
    private String relationNum;

}
