package com.yizhi.site.application.vo.site;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @description: 学员端首页返回
 * @author: lly
 * @date: 2019-01-10 20:43
 **/
@Data
@ApiModel(value = "学员端首页返回")
public class PortalPlateVO implements Serializable {
    @ApiModelProperty(value = "列表id")
    private Long id;

    @ApiModelProperty(value = "名称")
    private String name;
    @ApiModelProperty(value = "展示图片")
    private String image;
    @ApiModelProperty(value = "开始时间")
    private Date StartTime;
    @ApiModelProperty(value = "结束时间")
    private Date endTime;
    @ApiModelProperty(value = "课程学习人数")
    private Integer studyCount;
    @ApiModelProperty(value = "评价分")
    private String score;

    @ApiModelProperty(value = "类型")
    private String type;

    @ApiModelProperty(value = "活动类型 0.课程 1考试 2调研 3直播 4投票 5作业 6证书 7外部链接 8报名 9签到 10线下课程 11营销课程  12培训项目")
    private Integer activityType;

    @ApiModelProperty(value = "活动id")
    private Long activityId;


    @ApiModelProperty(value = "url")
    private String url;

    private Integer thumbnail;
    @ApiModelProperty(value = "课程 1 有效，0失效")
    private Integer valid;

    @ApiModelProperty(value = "homeId")
    private Long homeId;

    @ApiModelProperty(value = "templateId")
    private Long templateId;

    @ApiModelProperty(value = "模块名字")
    private String moduleName;

    @ApiModelProperty(value = "站点id")
    private Long siteId;

    @ApiModelProperty(value = "课程编码")
    private String courseNo;

    @ApiModelProperty(value = "排序")
    private Integer sort;

    @ApiModelProperty(value = "模块id")
    private Long plateId;

    @ApiModelProperty(value = "讲师头衔")
    private String title;

    @ApiModelProperty("课程时长")
    private Integer duration;

    @ApiModelProperty("学习时长")
    private Float totalDuration;

    @ApiModelProperty("总时长,字符串类型，解决整数去掉小数点后一位0的问题")
    private String totalDurationStr;

    @ApiModelProperty("课程学时显示 true 显示，false不显示")
    private Boolean courseDurationShow;

    @ApiModelProperty("培训项目数")
    private Integer activityCount;

    @ApiModelProperty(value = "创建人/作者")
    private String createByName;

    @ApiModelProperty(value = "点赞数")
    private Integer likeNum;

    @ApiModelProperty(value = "说明")
    private String directions;

    @ApiModelProperty(value = "课程：0:表示未完成，1表示已完成")
    private Integer status;

    @ApiModelProperty(value = "数量")
    private Integer num;

    @ApiModelProperty(value = "总数")
    private Integer total;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "观看类型：0: 公开播放 ; 1: 站内授权播放; ")
    private Integer viewType;

    @ApiModelProperty(value = "实际价格")
    private Integer actualPrice;

    @ApiModelProperty(value = "原价格")
    private Integer originalPrice;

}
