package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@ApiModel(value = "PortalNavigateEntityVo", description = "头部导航栏")
@Data
@TableName("tr_portal_navigate")
public class PortalNavigate extends Model<PortalNavigate> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "导航栏ID主键")
    private Long id;
    
    @ApiModelProperty(value = "首页ID")
    @TableField("home_id")
    private Long homeId;
    
    @ApiModelProperty(value = "站点ID")
    @TableField("site_id")
    private Long siteId;
    
    @ApiModelProperty(value = "显示名称")
    @TableField("show_name")
    private String showName;
    
    @ApiModelProperty(value = "图片路径")
    @TableField("img_path")
    private String imgPath;
    
    @ApiModelProperty(value = "关联功能类型,  自定义的为 1，  系统提供的为0")
    @TableField("relation_func")
    private Integer relationFunc;
    
    
    @ApiModelProperty(value = "关联功能编码")
    @TableField("relation_func_code")
    private String relationFuncCode;
    
    @ApiModelProperty(value = "关联功能名称")
    @TableField("relation_func_name")
    private String relationFuncName;
    
    @ApiModelProperty(value = "关联功能链接")
    @TableField("relation_func_url")
    private String relationFuncUrl;

    @ApiModelProperty(value = "显示状态, 0 不显示  1 显示")
    private Integer display;
    
    @ApiModelProperty(value = "排序")
    private Integer sort;
    
    @ApiModelProperty(value = "0: 删除  1:未发布 2：发布")
    private Integer state;
    
    @ApiModelProperty(value = "创建时间")
    @TableField("create_time")
    private Date createTime;
    
    @ApiModelProperty(value = "创建人")
    @TableField("create_by_id")
    private Long createById;
    
    @ApiModelProperty(value = "创建姓名")
    @TableField("create_by_name")
    private String createByName;
    
    @ApiModelProperty(value = "更新时间")
    @TableField("update_time")
    private Date updateTime;
    
    @ApiModelProperty(value = "更新人")
    @TableField("update_by_id")
    private Long updateById;
    
    @ApiModelProperty(value = "更新姓名")
    @TableField("update_by_name")
    private String updateByName;
    
    @ApiModelProperty(value = "pc端")
    @TableField("pc_type")
    private Integer pcType;

    @ApiModelProperty(value = "关联的id")
    @TableField("relation_id")
    private Long relationId;

    @ApiModelProperty(value = "关联的课程分类")
    private String classifyName;

    @ApiModelProperty(value = "1 学习时长排行榜,2 案例排行榜")
    private String relationNum;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }
}
