package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@ApiModel(value = "ProtalPlateEntityVo", description = "模板类型")
@Data
@TableName("tr_protal_plate")
public class ProtalPlate extends Model<ProtalPlate> {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "推荐/精选ID")
	private Long id;

	@ApiModelProperty(value = "模块ID")
	@TableField("template_id")
	private Long templateId;

	@ApiModelProperty(value = "新闻ID")
	@TableField("news_id")
	private Long newsId;
	
	@ApiModelProperty(value = "选择活动    推荐/精选  有  外链的id")
	@TableField("select_activity")
	private Long selectActivity;
	
	@ApiModelProperty(value = "选择活动名称    推荐/精选  有  外链的名字")
	@TableField("select_activity_name")
	private String selectActivityName;
	
	@ApiModelProperty(value = "是否推荐    推荐/精选  有  0 不推荐  1 推荐")
	@TableField("is_recommend")
	private Integer isRecommend;

	@ApiModelProperty(value = "id,  选择直播, 选择项目, 选择课程 有  推荐/精选 没有")
	@TableField("link_content")
	private Long linkContent;

	//7和13都是外链  但是7去培训项目找活动外联，13是纯外链和培训项目本身没有任何关系
	@ApiModelProperty(value = "链接活动类型  //0'课程'   1'考试' 2'调研' 3'直播' 4'投票' 5'作业' 6'证书'7'培训项目的外部链接活动'8'报名'9'签到'10'线下课程'11营销课程 12培训项目  13纯活动外联")
	@TableField("link_type")
	private Integer linkType;

    @ApiModelProperty(value = "课程编码")
    @TableField("course_no")
    private String courseNo;
	
	@ApiModelProperty(value = "选择直播, 选择项目, 选择课程  名称")
	@TableField("link_content_name")
	private String linkContentName;

	@ApiModelProperty(value = "pc:1使用内容图片 2使用新图片")
	private Integer thumbnail;

	@ApiModelProperty(value = "图片路径")
	@TableField("img_path")
	private String imgPath;

	@ApiModelProperty(value = "说明")
	private String directions;

	@ApiModelProperty(value = "0: 删除  1: 未发布  2： 发布")
	private Integer state;

	@ApiModelProperty(value = "创建时间")
	@TableField("create_time")
	private Date createTime;

	@ApiModelProperty(value = "创建人")
	@TableField("create_by_id")
	private Long createById;

	@ApiModelProperty(value = "创建姓名")
	@TableField("create_by_name")
	private String createByName;

	@ApiModelProperty(value = "更新时间")
	@TableField("update_time")
	private Date updateTime;

	@ApiModelProperty(value = "更新人")
	@TableField("update_by_id")
	private Long updateById;

	@ApiModelProperty(value = "更新姓名")
	@TableField("update_by_name")
	private String updateByName;
	
	@ApiModelProperty(value="排序规则")
	private Integer sort;
	
	@Override
	protected Serializable pkVal() {
		return this.id;
	}
}
