package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.yizhi.site.application.vo.domain.InformationClassify;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * com.yizhi.site.application.domain
 *
 * @author yanglang
 * @create 2024-12-17 13:14:46
 */
@ApiModel(value = "PublicationEntityVo", description = "投稿")
@Data
@TableName("publication")
public class Publication {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主鍵")
    private Long id;

    @ApiModelProperty(value = "封面logo")
    private String logoPath;

    @ApiModelProperty(value = "编号")
    private String number;

    @ApiModelProperty(value = "投稿标题")
    private String fileName;

    @ApiModelProperty(value = "投稿父类型  1： 新闻   2: 公告")
    private Long typeOne;

    @TableField(exist = false)
    private String typeOneName;

    @ApiModelProperty(value = "投稿子类型")
    private Long typeTwo;

    @TableField(exist = false)
    private String typeTwoName;

    @ApiModelProperty(value = "作者")
    private String author;

    @ApiModelProperty(value = "发布时间")
    private Date releaseTime;

    @ApiModelProperty(value = "投稿时间")
    private Date submitTime;

    @ApiModelProperty(value = "内容")
    private String content;

    @ApiModelProperty(value = "原文链接")
    private String linkUrl;

    @ApiModelProperty(value = "审核时间")
    private Date approveTime;

    @ApiModelProperty(value = "审批人")
    private Long approveById;

    @ApiModelProperty(value = "状态 0 删除 1 草稿 2 待审核 3 待发布 4 已发布 5 不通过")
    private Integer state;

    @ApiModelProperty(value = "站点ID")
    private Long siteId;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "创建人")
    private Long createById;

    @ApiModelProperty(value = "创建人姓名")
    private String createByName;

    @ApiModelProperty(value = "修改时间")
    private Date updateTime;

    @ApiModelProperty(value = "修改人")
    private Long updateById;

    @ApiModelProperty(value = "修改人姓名")
    private String updateByName;

    @ApiModelProperty(value = "图片或视频链接地址")
    private String ossUrl;

    @ApiModelProperty(value = "支部或部室")
    private String deptName;

    @ApiModelProperty(value = "投稿第三层类型")
    private Long typeThree;

    @TableField(exist = false)
    private String typeThreeName;

    @ApiModelProperty(value = "资讯分类")
    @TableField(exist = false)
    private List<InformationClassify> informationClassify;

    protected Serializable pkVal() {
        return this.id;
    }
}
