package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@ApiModel(value = "SiteEntityVo", description = "站点")
@Data
@TableName("site")
public class Site extends Model<Site> {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "主键")
	private Long id;

	@ApiModelProperty(value = "站点名称")
	private String name;

	@ApiModelProperty(value = "站点编码")
	private String code;

	@ApiModelProperty(value = "存放路径")
	@TableField("logo_path")
	private String logoPath;

	@ApiModelProperty(value = "站点前台访问地址")
	@TableField("reception_add")
	private String receptionAdd;

	@ApiModelProperty(value = "自定义访问地址")
	@TableField("customize_add")
	private String customizeAdd;

	@ApiModelProperty(value = "关联部门, 多个用，隔开")
	@TableField("related_org")
	private Long relatedOrg;

	@ApiModelProperty(value = "0停用 1启用")
	private Integer state;

	@ApiModelProperty(value = "0不是 1是")
	private Integer main;

	@ApiModelProperty(value = "父站点ID")
	private Long parentId;

	@ApiModelProperty(value = "创建时间")
	@TableField("create_time")
	private Date createTime;

	@ApiModelProperty(value = "创建人ID")
	@TableField("create_by_id")
	private Long createById;

	@ApiModelProperty(value = "创建人姓名")
	@TableField("create_by_name")
	private String createByName;

	@ApiModelProperty(value = "修改时间")
	@TableField("update_time")
	private Date updateTime;

	@ApiModelProperty(value = "修改人ID")
	@TableField("update_by_id")
	private Long updateById;

	@ApiModelProperty(value = "修改人姓名")
	@TableField("update_by_name")
	private String updateByName;

	@ApiModelProperty(value = "公司ID")
	@TableField("company_id")
	private Long companyId;

	@ApiModelProperty(value = "1: 统一站点  0: 多站点")
	private Integer unite;

	@ApiModelProperty(value = "部门ID")
	@TableField("org_id")
	private Long orgId;

	@Override
	protected Serializable pkVal() {
		return this.id;
	}
}
