package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author fulan123
 * @since 2018-12-11
 */
@Data
@Api(tags = "TrPortalPageBottomEntityVo", description = "")
@TableName("tr_portal_page_bottom")
public class TrPortalPageBottom extends Model<TrPortalPageBottom> {

    private static final long serialVersionUID = 1L;


@ApiModelProperty(value = "主键ID")
	private Long id;

@ApiModelProperty(value = "主页ID")
	@TableField("page_id")
	private Long pageId;

@ApiModelProperty(value = "1代表文案，2代表链接")
	private Integer type;

@ApiModelProperty(value = "针对链接，如果1链接名字显示，如果2链接名字不显示")
	private Integer display;

@ApiModelProperty(value = "如果是文案，这列是文案信息，如果是链接，这列是链接名字，最多都是六个字")
	private String content;

@ApiModelProperty(value = "文字链接/图片链接")
@TableField("content_type")
private Integer contentType;

@ApiModelProperty(value = "排序规则")
	private Integer sort;

@ApiModelProperty(value = "0删除1未删除")
private Integer state;

	@TableField(value = "create_time", fill = FieldFill.INSERT)
	private Date createTime;

	@TableField(value = "create_by_id", fill = FieldFill.INSERT)
	private Long createById;

	@TableField(value = "create_by_name", fill = FieldFill.INSERT)
	private String createByName;

	@TableField(value = "update_time", fill = FieldFill.INSERT)
	private Date updateTime;

	@TableField(value = "update_by_id", fill = FieldFill.INSERT)
	private Long updateById;

	@TableField(value = "update_by_name", fill = FieldFill.INSERT)
	private String updateByName;


	@Override
	protected Serializable pkVal() {
		return this.id;
	}

}
