package com.yizhi.site.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.yizhi.site.application.domain.EventTrack;
import com.yizhi.site.application.vo.site.*;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;


/**
 * com.yizhi.site.application.mapper
 *
 * @author yanglang
 * @create 2025-01-14 10:14:28
 */
public interface EventTrackMapper extends BaseMapper<EventTrack> {

    EventTrackDayNumVo getTodayNum(@Param("date") String date,@Param("siteId") Long siteId);

    EventTrackDayNumVo getTodayNumByLogin(@Param("date") String date,@Param("siteId") Long siteId);

    DayNumVo getNumByLogin(@Param("date") String date,@Param("dateString") String dateString,@Param("siteId") Long siteId);

    DayNumVo getNumByType(@Param("date") String date,@Param("dateString") String dateString,@Param("types")List<Integer> types,@Param("siteId") Long siteId, @Param("weekStartDate") String weekStartDate, @Param("weekEndDate") String weekEndDate);
    DayNumVo getTgNumByType(@Param("date") String date,@Param("dateString") String dateString,@Param("siteId") Long siteId);

    List<EventTrackTypeNumVo> queryNumByType(@Param("deptId") Long deptId,@Param("date") String date,@Param("dateString") String dateString,@Param("types")List<Integer> types,@Param("subNameList")List<String> subNameList,@Param("siteId") Long siteId,
                                             @Param("isPre") Boolean isPre);

    List<EventTrackTypeNumVo> queryNumByTypeInformation(@Param("deptId") Long deptId,@Param("date") String date,@Param("dateString") String dateString,@Param("types")List<Integer> types,@Param("subNameList")List<Long> subNameList,@Param("siteId") Long siteId,
                                                        @Param("isPre") Boolean isPre);

    List<EventTrackTypeNumVo> queryTgNumByDept(@Param("deptName") String deptName,@Param("typeId")Long typeId,@Param("siteId") Long siteId);

    List<EventTrackTypeNumVo> queryDeptByType(@Param("deptId") Long deptId, @Param("dateString") String dateString, @Param("types")List<Integer> types,@Param("siteId") Long siteId);

    Integer getNum(@Param("type")Integer type, @Param("businessId")Long businessId,@Param("siteId") Long siteId);

    Integer getFavoriteNum(@Param("businessId")Long businessId,@Param("siteId") Long siteId);

    List<EventTrackDeptNumVo> queryGropByList(@Param("siteId") Long siteId);

    Integer getExamTotal(@Param("subType")String subType,@Param("year")String year,@Param("siteId") Long siteId);

    Integer getResearchTotal(@Param("year")String year,@Param("siteId") Long siteId);

    Integer getResearchJoinTotal(@Param("year")String year,@Param("siteId") Long siteId);
    
    Integer getCommentNum(@Param("businessId")Long businessId,@Param("siteId") Long siteId);
    
    DayNumVo getMailTgNumByType(@Param("date") String date,@Param("dateString") String dateString,@Param("siteId") Long siteId, @Param("weekStartDate") String weekStartDate, @Param("weekEndDate") String weekEndDate);

    @MapKey("subType")
    Map<String, EventTrackTypeNumVo> queryTrainningNumBydeptId();

    @MapKey("subType")
    Map<String, EventTrackTypeNumVo> queryExamNumBydeptId();

    List<EventTrackRankListVo> queryRankListByUser(@Param("date") String date,@Param("dateString") String dateString);

    List<EventTrackRankListVo> queryRankListByDept(@Param("date") String date,@Param("dateString") String dateString);
}
