package com.yizhi.site.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.site.application.domain.International;
import com.yizhi.site.application.vo.site.InternationalVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 国际化的Mapper 接口
 * </p>
 *
 * @author lingye
 * @since 2020-08-13
 */
public interface InternationalMapper extends BaseMapper<International> {
    /**
     * 管理查询 国际化列表列表
     *
     * @param type
     * @param languageId
     * @param keywords
     * @param state
     * @return
     */
    List<InternationalVO> queryInternationalList(@Param("type") Integer type,
                                                 @Param("languageId") Long languageId,
                                                 @Param("keywords") String keywords,
                                                 @Param("state") Integer state,
                                                 Page<InternationalVO> page);

    /**
     * 总数
     *
     * @param languageId
     * @param keywords
     * @param state
     * @return
     */
    Integer queryInternationalCount(@Param("type") Integer type,
                                    @Param("languageId") Long languageId,
                                    @Param("keywords") String keywords,
                                    @Param("state") Integer state);

    /**
     * 获取列表
     *
     * @param keyIds
     * @param languageId
     * @param keywords
     * @param state
     * @return
     */
    List<InternationalVO> queryInternationalList(@Param("type") Integer type,
                                                 @Param("languageId") Long languageId,
                                                 @Param("keywords") String keywords,
                                                 @Param("state") Integer state);

}
