package com.yizhi.site.application.service;

import java.util.List;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.IService;
import com.yizhi.site.application.domain.Information;
import com.yizhi.site.application.vo.domain.InformationVo;
import com.yizhi.site.application.vo.site.*;


/**
 * <p>
 * 服务类
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
public interface InformationService extends IService<Information> {


    InformationListVO informationPageList(InfoVO vo);

    /**
     * 根据分类id查询资讯
     */
    List<Information> selectInformation(Long typeTwo);

    Page<Information> informationList(InfomationParamVO vo);

    Long insertInformation(Information information);

	Long insertInformation(Information information,Long id);

    /**
     * 资讯发布（批量）
     */
    boolean releases(ParamVO vo);

    /**
     * 新闻资讯上架
     *
     * @param id 新闻公告id
     * @return
     */

    boolean releaseInfomation(Long id );

	/**
	 * 资讯取消发布（批量）
	 */
	boolean unreleases(ParamVO vo);

	/**
	 * 根据新闻,公告查询资讯
	 */
	Page<InformationStudentVO> informationList(Long typeOne, Integer pageNo, Integer pageSize, Long siteId);

	/**
	 * 根据id查询资讯
	 */
	Information getInformation(Long id, Long siteId);

	/**
	 * 首页 搜索新闻公告
	 */
	List<Information> searchInformation(Page<Information> page, Information info);

	/**
	 * 轮播图 类型 新闻模糊搜索
	 */
	List<Information> listbyName(String name, Long siteId);

	Information informationView(Long id);

	Boolean top(Long id);

    public boolean timeUpInfomation( Long id);

    InformationListPcVo informationPcPageList(InfoVO infoVO);

    InformationListPcVo informationPcPageListV2(InfoVO infoVO);

    InformationViewVO getPcInformation(IdOneVO idOneVO);






    /**
     * ----------------------华丽的分割线---------------------------------
     */

    List<Information> getRelationAnnouncementPC(Long terminalId);


    Page<Information> getInformationByTypeOne(Long typeOne,Integer pageNo,Integer pageSize,Long siteId,List<Long> listIds);



	 Page<Information> getAllAnnouncementPC(Long terminalId,Integer pageNo,Integer pageSize);


	 Page<Information> getAllNewsPC(Long terminalId,Integer pageNo,Integer pageSize);


    List<Information> getRelationInformation(Long id);


    List<AnnouncementVO> getApiRelationAnnouncement(Long siteId, Integer terminalType);


    List<Information> listSupplyInformation(Long siteId,List<Long> ids);


	List<ImageListVO> listBannerImages(InfoVO infoVO);

	Page<Information> informationReleaseList(InfomationParamReleaseVO vo);

    List<InformationVo> listbyIds(List<Long> idList);
}
