package com.yizhi.site.application.service.impl;

import java.util.*;
import java.util.logging.Logger;
import java.util.stream.Collectors;

import cn.hutool.core.collection.CollectionUtil;
import com.yizhi.site.application.domain.DataClassification;
import com.yizhi.site.application.mapper.DataClassificationMapper;
import com.yizhi.site.application.mapper.InformationMapper;
import com.yizhi.site.application.service.DataClassificationService;
import com.yizhi.site.application.constant.SiteConstant;
import com.yizhi.site.application.service.InformationService;
import com.yizhi.site.application.service.PortalBannerService;
import com.yizhi.site.application.vo.domain.DataClassificationVo;
import com.yizhi.site.application.vo.site.IdTwoVO;
import com.yizhi.site.application.vo.site.RespVO;
import com.yizhi.site.application.vo.site.SiteComponyIdVO;
import com.yizhi.site.application.vo.site.ClassificationVO;
import lombok.extern.slf4j.Slf4j;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.application.orm.id.IdGenerator;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@Service
@Slf4j
public class DataClassificationServiceImpl extends ServiceImpl<DataClassificationMapper, DataClassification>
		implements DataClassificationService {

	@Autowired
	private DataClassificationMapper dataClassificationMapper;
	@Autowired
	IdGenerator idGenerator;
	@Autowired
	DataClassificationService dataClassificationService;
	@Autowired
    PortalBannerService portalBannerService;

	@Autowired
    private InformationService informationService;

	@Autowired
    private InformationMapper informationMapper;

    @Override
	public List<DataClassification> getSon(Long parentId) {
		DataClassification data = new DataClassification();
		data.setParentId(parentId);
		data.setState(1);
		EntityWrapper<DataClassification> wrapper = new EntityWrapper<DataClassification>(data);
		List<String> list = new ArrayList<String>();
		list.add("sort");
		wrapper.orderAsc(list);
		return this.selectList(wrapper);
	}

	@Override
	public List<ClassificationVO> getClassification(SiteComponyIdVO siteComponyIdVO) {
		Long siteId = siteComponyIdVO.getSiteId();
		log.info("查询的站点id:{}",siteId);
		Long createById = siteComponyIdVO.getCreateById();
		String createByName = siteComponyIdVO.getCreateByName();
		ClassificationVO classificationVO = null;
		Date date = new Date();
		// 防止并发添加数据
		List<ClassificationVO> list = dataClassificationMapper.selectSonClassification(siteId);
		if (list == null || list.size() < 1) {
			/*//没有初始化的数据，2024-12-16注释
			synchronized (this) {
				DataClassification dataClassification = new DataClassification();

                dataClassification.setId(idGenerator.generate());
                dataClassification.setName("公告");
                dataClassification.setDescription("公告");
                dataClassification.setParentId(0L);
                dataClassification.setSiteId(siteId);
                dataClassification.setCreateById(createById);
                dataClassification.setCreateByName(createByName);
                dataClassification.setUpdateById(createById);
                dataClassification.setUpdateByName(createByName);
                dataClassification.setSort(1L);
                dataClassification.setState(1);
                dataClassification.setCreateTime(date);
                dataClassification.setUpdateTime(date);
                dataClassificationService.insert(dataClassification);
                classificationVO = new ClassificationVO();
                BeanUtils.copyProperties(dataClassification, classificationVO);
                list.add(classificationVO);


				dataClassification.setId(idGenerator.generate());
				dataClassification.setName("新闻");
				dataClassification.setDescription("新闻");
				dataClassification.setParentId(0L);
				dataClassification.setSiteId(siteId);
				dataClassification.setCreateById(createById);
				dataClassification.setCreateByName(createByName);
				dataClassification.setUpdateById(createById);
				dataClassification.setUpdateByName(createByName);
				dataClassification.setSort(2L);
				dataClassification.setState(1);
				dataClassification.setCreateTime(date);
				dataClassification.setUpdateTime(date);
				dataClassificationService.insert(dataClassification);
				classificationVO = new ClassificationVO();
				BeanUtils.copyProperties(dataClassification, classificationVO);
				list.add(classificationVO);

			}*/
		} else {
			Map<String, Object> map = null;
			for(ClassificationVO vo : list) {
				List<String> wrapperList = new ArrayList<String>();
				wrapperList.add("sort");
				if (vo.getId() != 0L) {
					EntityWrapper<DataClassification> wrapper = new EntityWrapper<>();
					wrapper.eq("state", 1);
					wrapper.eq("parent_id", vo.getId());
					wrapper.orderAsc(wrapperList);
					List<DataClassification> selectByMap = dataClassificationService.selectList(wrapper);
					List<DataClassificationVo> selectVoByMap = new ArrayList<>();
					if (CollectionUtil.isNotEmpty(selectByMap)) {
						for (DataClassification d : selectByMap) {
							DataClassificationVo entityVo = new DataClassificationVo();
							BeanUtils.copyProperties(d, entityVo);
							selectVoByMap.add(entityVo);

							//获取子节点
							EntityWrapper<DataClassification> wrapperChild = new EntityWrapper<>();
							wrapperChild.eq("state", 1);
							wrapperChild.eq("parent_id", entityVo.getId());
							wrapperChild.orderAsc(wrapperList);
							List<DataClassification> classificationChild = dataClassificationService.selectList(wrapperChild);
							List<DataClassificationVo> childClassifyNews = new ArrayList<>();
							if (CollectionUtil.isNotEmpty(classificationChild)) {
								for (DataClassification child : classificationChild) {
									DataClassificationVo entityChild = new DataClassificationVo();
									BeanUtils.copyProperties(child, entityChild);
									childClassifyNews.add(entityChild);
								}
								entityVo.setChildClassifyNews(childClassifyNews);
								;
							}
						}
					}
					vo.setData(selectVoByMap);
				}
			}
		}
		return list;
	}
	@Override
	public List<ClassificationVO> getClassificationAndCommentNum(SiteComponyIdVO siteComponyIdVO) {
		Long siteId = siteComponyIdVO.getSiteId();
		log.info("查询的站点id:{}",siteId);
		Long createById = siteComponyIdVO.getCreateById();
		String createByName = siteComponyIdVO.getCreateByName();
		ClassificationVO classificationVO = null;
		Date date = new Date();
		// 防止并发添加数据
		List<ClassificationVO> list = dataClassificationMapper.selectSonClassification(siteId);
		if (list == null || list.size() < 1) {
			/*//没有初始化的数据，2024-12-16注释
			synchronized (this) {
				DataClassification dataClassification = new DataClassification();

                dataClassification.setId(idGenerator.generate());
                dataClassification.setName("公告");
                dataClassification.setDescription("公告");
                dataClassification.setParentId(0L);
                dataClassification.setSiteId(siteId);
                dataClassification.setCreateById(createById);
                dataClassification.setCreateByName(createByName);
                dataClassification.setUpdateById(createById);
                dataClassification.setUpdateByName(createByName);
                dataClassification.setSort(1L);
                dataClassification.setState(1);
                dataClassification.setCreateTime(date);
                dataClassification.setUpdateTime(date);
                dataClassificationService.insert(dataClassification);
                classificationVO = new ClassificationVO();
                BeanUtils.copyProperties(dataClassification, classificationVO);
                list.add(classificationVO);


				dataClassification.setId(idGenerator.generate());
				dataClassification.setName("新闻");
				dataClassification.setDescription("新闻");
				dataClassification.setParentId(0L);
				dataClassification.setSiteId(siteId);
				dataClassification.setCreateById(createById);
				dataClassification.setCreateByName(createByName);
				dataClassification.setUpdateById(createById);
				dataClassification.setUpdateByName(createByName);
				dataClassification.setSort(2L);
				dataClassification.setState(1);
				dataClassification.setCreateTime(date);
				dataClassification.setUpdateTime(date);
				dataClassificationService.insert(dataClassification);
				classificationVO = new ClassificationVO();
				BeanUtils.copyProperties(dataClassification, classificationVO);
				list.add(classificationVO);

			}*/
		} else {
			// 用于汇总所有分类的评论数量
			int totalCommentNum = 0;
			
			Map<String, Object> map = null;
			for(ClassificationVO vo : list) {
				List<String> wrapperList = new ArrayList<String>();
				wrapperList.add("sort");

				// 移除了 vo.getId() != 0L 的判断，确保所有分类都会被处理
				if(vo.getId() != 0L){

				EntityWrapper<DataClassification> wrapper = new EntityWrapper<>();
				wrapper.eq("state", 1);
				wrapper.eq("parent_id", vo.getId());
				wrapper.orderAsc(wrapperList);
				List<DataClassification> selectByMap = dataClassificationService.selectList(wrapper);
				List<DataClassificationVo> selectVoByMap = new ArrayList<>();
				// 父类的评论数量累计值
				int parentCommentNum = 0;

				if (CollectionUtil.isNotEmpty(selectByMap)) {
					// 创建一个Map来存储分类ID和评论数量的映射关系
					Map<Long, Integer> commentCountMap = getCommentCountForClassifications(selectByMap, siteId);

					for (DataClassification d : selectByMap) {
						DataClassificationVo entityVo = new DataClassificationVo();
						BeanUtils.copyProperties(d, entityVo);
						// 获取该分类的评论数量
						int classificationCommentNum = commentCountMap.getOrDefault(d.getId(), 0);
						// 设置该分类的评论数量
						entityVo.setCommentNum(classificationCommentNum);
						// 累加到父类的评论数量
						parentCommentNum += classificationCommentNum;
						// 累加到总评论数量
						totalCommentNum += classificationCommentNum;
						selectVoByMap.add(entityVo);

						//获取子节点
						EntityWrapper<DataClassification> wrapperChild = new EntityWrapper<>();
						wrapperChild.eq("state", 1);
						wrapperChild.eq("parent_id", entityVo.getId());
						wrapperChild.orderAsc(wrapperList);
						List<DataClassification> classificationChild = dataClassificationService.selectList(wrapperChild);
						List<DataClassificationVo> childClassifyNews = new ArrayList<>();
						if (CollectionUtil.isNotEmpty(classificationChild)) {
							// 创建一个Map来存储子分类ID和评论数量的映射关系
							Map<Long, Integer> childCommentCountMap = getCommentCountForClassifications(classificationChild, siteId);

							for (DataClassification child : classificationChild) {
								DataClassificationVo entityChild = new DataClassificationVo();
								BeanUtils.copyProperties(child, entityChild);
								// 获取该子分类的评论数量
								int childCommentNum = childCommentCountMap.getOrDefault(child.getId(), 0);
								// 设置该子分类的评论数量
								entityChild.setCommentNum(childCommentNum);
								// 累加到父类的评论数量
								parentCommentNum += childCommentNum;
								// 累加到总评论数量
								totalCommentNum += childCommentNum;
								childClassifyNews.add(entityChild);
							}
							entityVo.setChildClassifyNews(childClassifyNews);
						}
					}
				}
				// 设置父类的评论数量（所有子类评论数量的累加）
				vo.setCommentNum(parentCommentNum);
				vo.setData(selectVoByMap);
			}

			}
			
			// 为ID为0的分类设置总评论数量
			for (ClassificationVO vo : list) {
				if (vo.getId() == 0L) {
					vo.setCommentNum(totalCommentNum);
//					break;
				}
			}
		}
		return list;
	}

	/**
	 * 获取分类列表的评论数量
	 * @param classifications 分类列表
	 * @param siteId 站点ID
	 * @return 分类ID和评论数量的映射关系
	 */
	private Map<Long, Integer> getCommentCountForClassifications(List<DataClassification> classifications, Long siteId) {
		Map<Long, Integer> commentCountMap = new HashMap<>();
		if (CollectionUtils.isEmpty(classifications)) {
			return commentCountMap;
		}

		// 提取分类ID列表
		List<Long> classificationIds = new ArrayList<>();
		for (DataClassification classification : classifications) {
			classificationIds.add(classification.getId());
		}

		// 通过SQL查询获取这些分类下的资讯评论数量
		List<Map<String, Object>> commentCounts = dataClassificationMapper.getCommentCountForClassifications(classificationIds, siteId);

		// 将查询结果转换为Map
		for (Map<String, Object> commentCount : commentCounts) {
			Long classificationId = (Long) commentCount.get("classificationId");
			Long count = (Long) commentCount.get("commentCount");
			commentCountMap.put(classificationId, count != null ? count.intValue() : 0);
		}

		return commentCountMap;
	}

	@Override
	public Boolean insertClassification(DataClassification dataClassification) {
		Long sort = dataClassificationMapper.selectMaxSort(dataClassification.getParentId());
		if (sort == null) {
			sort = 0L;
		}
		dataClassification.setSort(sort + 1);
		dataClassification.setId(idGenerator.generate());
		dataClassification.setState(SiteConstant.FIRST);
		return this.insert(dataClassification);
	}

	@Override
	public List<DataClassification> selectParent(RequestContext context) {
		DataClassification dataClassification = new DataClassification();
		dataClassification.setSiteId(context.getSiteId());
		dataClassification.setParentId(0L);
		EntityWrapper<DataClassification> wrapper = new EntityWrapper<DataClassification>(dataClassification);
		List<String> list = new ArrayList<String>();
		list.add("sort");
		wrapper.orderAsc(list);
		return this.selectList(wrapper);
	}

	@Override
	public Boolean dragClassify(IdTwoVO vo) {
		Date date = new Date();
		Long sourceId = vo.getSourceId();
		Long targetId = vo.getTargetId();
		DataClassification source = dataClassificationService.selectById(sourceId);
		DataClassification target = dataClassificationService.selectById(targetId);
		Long sourceSort = source.getSort();
		Long targetSort = target.getSort();
		source.setSort(targetSort);
		source.setUpdateById(vo.getAccountId());
		source.setUpdateByName(vo.getAccountName());
		source.setUpdateTime(date);
		dataClassificationService.updateById(source);
		target.setSort(sourceSort);
		target.setUpdateById(vo.getAccountId());
		target.setUpdateByName(vo.getAccountName());
		target.setUpdateTime(date);
		dataClassificationService.updateById(target);
		return true;
	}

    /**
     *  删除儿子分类
     * @param id 二级分类的Id
     * @return
     */
    @Override
    @Transactional
    public RespVO delClassify(Long id) {

      Integer count =   informationMapper.queryInformationByTypeTwo(id);
        if (count>0){
            RespVO respVO = new RespVO();
            respVO.setSubMsg("分类下有记录，不能删除！如确认删除，先删除此分类下的数据");
            return respVO;
        } else {
            DataClassification classification = new DataClassification();
            classification.setId(id);
            classification.setState(0);
             this.updateById(classification);
             return null;
        }
    }

	@Override
	public List<DataClassification> getSubcategories(Long siteId, Long typeOne) {
		return dataClassificationMapper.getSubcategories(siteId,typeOne);
	}

	@Override
	public List<DataClassificationVo> getAllClassification(SiteComponyIdVO siteComponyIdVO, Long parentId) {
		Long siteId = siteComponyIdVO.getSiteId();
		log.info("查询的站点id:{}",siteId);
		Long createById = siteComponyIdVO.getCreateById();
		String createByName = siteComponyIdVO.getCreateByName();
		ClassificationVO classificationVO = null;
		Date date = new Date();
		int level = 0;
		if(parentId == 0){
			level = 0;
		} else {
			level = 1;
		}
		//获取根节点下的所有节点，只遍历二级
		List<DataClassificationVo> rootList = dataClassificationMapper.selectClassification(siteId, parentId);
		if (CollectionUtils.isNotEmpty(rootList)) {
			Long childParentId = null;
			//遍历根节点
			for(DataClassificationVo root : rootList){
				//获取子节点（一级）
				childParentId = root.getId();
				List<DataClassificationVo> childListOne = dataClassificationMapper.selectClassification(siteId, childParentId);
				if (CollectionUtils.isNotEmpty(childListOne)) {
					//遍历一级节点
					for(DataClassificationVo rootOne : childListOne){
						//获取子节点（二级）
						childParentId = rootOne.getId();
						List<DataClassificationVo> childListTwo = dataClassificationMapper.selectClassification(siteId, childParentId);
						if (CollectionUtils.isNotEmpty(childListTwo)) {
							rootOne.setChildClassifyNews(childListTwo);
							
							for(DataClassificationVo rootTwo : childListTwo){
								rootTwo.setLevel(level + 3);
							}
						}
						
						rootOne.setLevel(level + 2);
					}
					root.setChildClassifyNews(childListOne);
				}
				
				root.setLevel(level + 1);
			}
		}
		return rootList;
	}

}
