package com.yizhi.site.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.core.application.cache.CacheNamespace;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.task.AbstractTaskHandler;
import com.yizhi.core.application.task.TaskExecutor;
import com.yizhi.site.application.domain.International;
import com.yizhi.site.application.domain.InternationalKey;
import com.yizhi.site.application.domain.SiteDic;
import com.yizhi.site.application.mapper.InternationalMapper;
import com.yizhi.site.application.service.IInternationalKeyService;
import com.yizhi.site.application.service.IInternationalService;
import com.yizhi.core.application.exception.BizException;
import com.yizhi.core.application.log.LogQueue;
import com.yizhi.core.application.log.TaskLogDetailEvent;
import com.yizhi.site.application.enums.ImportError;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.site.application.service.ISiteDicService;
import com.yizhi.site.application.vo.site.InternationalImport;
import com.yizhi.site.application.vo.site.InternationalVO;
import com.yizhi.system.application.model.ImportModel;
import com.yizhi.util.application.constant.ReturnCode;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author lingye
 * @since 2020-08-13
 */
@Service
@Log4j2
public class InternationalServiceImpl extends ServiceImpl<InternationalMapper, International> implements IInternationalService {

    @Autowired
    private IdGenerator idGenerator;
    /*@Autowired
    private RabbitTemplate rabbitTemplate;*/
    @Autowired
    private IInternationalKeyService internationalKeyService;
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private ISiteDicService siteDicService;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private IInternationalService internationalService;

    @Override
    public Page<InternationalVO> findInternationalPage(Integer type, Long languageId, String keywords, Integer sate, Integer pageNo, Integer pageSize) {
        Page<InternationalVO> page = new Page<>(pageNo, pageSize);

        log.info("page123:{}", JSON.toJSON(page));
        List<InternationalVO> internationalVOS = this.baseMapper.queryInternationalList(type, languageId, keywords, sate, page);
        Integer total = this.baseMapper.queryInternationalCount(type, languageId, keywords, sate);
        //组装Vo
        Page<InternationalVO> internationalVOPage = new Page<>();
        internationalVOPage.setTotal(CollectionUtils.isEmpty(internationalVOS) ? 0 : total);
        internationalVOPage.setRecords(internationalVOS);
        internationalVOPage.setCurrent(pageNo);
        internationalVOPage.setSize(pageSize);
        return internationalVOPage;
    }


    @Override
    public List<InternationalVO> findInternationalList(Integer type, Long languageId, String keywords, Integer sate) {
        List<InternationalVO> internationalVOS = this.baseMapper.queryInternationalList(type, languageId, keywords, sate);
        return internationalVOS;
    }

    /**
     * 导入国际化
     *
     * @param importModel
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<InternationalImport> importInternationalList(ImportModel importModel, RequestContext context, Long languageId, Integer type) {

        List<InternationalImport> models = importModel.getData();
        Long taskId = importModel.getTaskId();

        if (CollectionUtils.isNotEmpty(models)) {
            List<TaskLogDetailEvent> failEvents = new ArrayList<TaskLogDetailEvent>();
            List<International> updateInternationalList = new ArrayList<>(models.size());
            List<International> insertInternationalList = new ArrayList<>(models.size());
            //拿取对应的终端的key
            Map<String, Long> keyMap = internationalKeyService.getKeyMap(type, null);
            //需要新增的key
            List<InternationalKey> insertInternationalKeys = new ArrayList<>(models.size());
            List<InternationalKey> updateInternationalKeys = new ArrayList<>(models.size());
            //拿取对应语种的翻译数据
            //<internationalKeyId+languageId,internationalId>
            Map<String, Long> valueMap = this.getValueMap(languageId);

            //同一个excel是否存在重复key
            List<String> keyListInFile = new ArrayList<String>();
            Long internationalKeyId = null;
            for (int j = 0; j < models.size(); j++) {
                int i = j + 1;
                InternationalImport model = models.get(j);
                String key = model.getKey();

                //检查数据 规范
                if (check(key, model, i, taskId, keyListInFile, failEvents) < 0) {
                    continue;
                }
                keyListInFile.add(key);
                if (keyMap != null) {
                    Long keyId = keyMap.get(key);
                    //判断数据库不存在该key
                    if (keyId == null) {
                        internationalKeyId = idGenerator.generate();
                        //获取需要保存的key
                        buildInternationalKey(model, type, internationalKeyId, context, insertInternationalKeys);
                        //key不存在，那么value肯定是新增
                        buildInsertInternational(model, type, languageId, internationalKeyId, context, insertInternationalList);
                    } else {
                        //key值存在，则继续判断对应的翻译值是否存在
                        if (valueMap != null) {
                            String k = keyId + "_" + languageId;
                            Long valueId = valueMap.get(k);
                            //存在value值更新
                            if (valueId != null) {
                                buildUpdateInternational(model, valueId, context, updateInternationalList);
                                buildUpdateInternationalKey(model,keyId,context,updateInternationalKeys);
                            } else {
                                //一般来讲这里是不会走到这里
                                buildInsertInternational(model, type, languageId, keyId, context, insertInternationalList);
                            }
                        }
                    }
                } else {
                    internationalKeyId = idGenerator.generate();
                    //获取需要保存的key
                    buildInternationalKey(model, type, internationalKeyId, context, insertInternationalKeys);
                    //key不存在，那么value肯定是新增
                    buildInsertInternational(model, type, languageId, internationalKeyId, context, insertInternationalList);
                }
                model.setResult("");
            }
            if (CollectionUtils.isNotEmpty(insertInternationalKeys)) {
                internationalKeyService.insertBatch(insertInternationalKeys);
            }
            if (CollectionUtils.isNotEmpty(updateInternationalKeys)) {
                internationalKeyService.updateBatchById(updateInternationalKeys);
            }
            if (CollectionUtils.isNotEmpty(insertInternationalList)) {
                this.insertBatch(insertInternationalList);
            }
            if (CollectionUtils.isNotEmpty(updateInternationalList)) {
                this.updateBatchById(updateInternationalList);
            }
            String key = CacheNamespace.SITE_LANGUAGE_INTERNATIONAL_WORD + type;
            SiteDic siteDic = siteDicService.selectById(languageId);
            if (siteDic != null) {
                String[] item = new String[]{siteDic.getCode()};
                redisCache.hdel(key, item);
            }
            if (CollectionUtils.isNotEmpty(failEvents)) {
                //rabbitTemplate.convertAndSend(LogQueue.BATCH_TASK_LOG_DETAIL_QUEUE, failEvents);
            }
            insertOtherLanguage(type, languageId, context);
            return models;
        } else {
            throw new BizException(ReturnCode.RESOURCE_NOT_FOUND.getCode(), ReturnCode.RESOURCE_NOT_FOUND.getMsg());
        }
    }

    /**
     * 检查excel数据规范
     *
     * @param key
     * @param model
     * @param i
     * @param taskId
     * @param keyListInFile
     * @param failEvents
     * @return
     */
    private int check(String key, InternationalImport model, int i, Long taskId, List<String> keyListInFile, List<TaskLogDetailEvent> failEvents) {

        if (StringUtils.isBlank(key) || StringUtils.isBlank(model.getPreTranslation())) {
            model.setResult(ImportError.KEY_EMPTY + "或" + ImportError.PRE_TRANSLATION_EMPTY);
            failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImportError.KEY_EMPTY + "或" + ImportError.PRE_TRANSLATION_EMPTY));
            return -1;
        }
        // 检查文件中是否有重名
        if (keyListInFile.contains(key)) {
            model.setResult(ImportError.KEY_EXIST_IN_FILE);
            failEvents.add(new TaskLogDetailEvent(taskId, "第" + i + "行:" + ImportError.KEY_EXIST_IN_FILE));
            return -1;
        }
        return 1;
    }

    /**
     * 获取需要保存的key
     *
     * @param model                   数据
     * @param type                    终端类型
     * @param internationalKeyId      keyId
     * @param insertInternationalKeys
     * @return
     */
    private void buildInternationalKey(InternationalImport model, Integer type, Long internationalKeyId, RequestContext context, List<InternationalKey> insertInternationalKeys) {
        if (StringUtils.isNotBlank(model.getKey())) {
            InternationalKey internationalKey = new InternationalKey();
            internationalKey.setId(internationalKeyId);
            internationalKey.setInternationalKey(model.getKey());
            internationalKey.setCreateById(context.getAccountId());
            internationalKey.setCreateTime(new Date());
            internationalKey.setType(type);
            internationalKey.setPreTranslation(model.getPreTranslation());
            internationalKey.setTranslateRemark(model.getTranslationRemark());
            insertInternationalKeys.add(internationalKey);
        } else {
            log.error("key值为空，传参：{}", JSON.toJSONString(model));
        }
    }
    /**
     * 获取需要保存的key
     *
     * @param model                   数据
     * @param keyId      keyId
     * @param updateInternationalKeys
     * @return
     */
    private void buildUpdateInternationalKey(InternationalImport model, Long keyId, RequestContext context, List<InternationalKey> updateInternationalKeys) {
        if (StringUtils.isNotBlank(model.getKey())) {
            InternationalKey internationalKey = new InternationalKey();
            internationalKey.setId(keyId);
            internationalKey.setPreTranslation(model.getPreTranslation());
            internationalKey.setTranslateRemark(model.getTranslationRemark());
            internationalKey.setUpdateById(context.getAccountId());
            internationalKey.setUpdateTime(new Date());
            updateInternationalKeys.add(internationalKey);
            //异步修改
            asynUpdate(model.getTranslationRemark(),model.getPreTranslation(),keyId,new Date(),context);
        } else {
            log.error("key值为空，传参：{}", JSON.toJSONString(model));
        }
    }

    /**
     * 获取需要保存的value
     *
     * @param model
     * @param type
     * @param internationalKeyId
     * @param context
     * @param insertInternationals
     */
    private void buildInsertInternational(InternationalImport model, Integer type, Long languageId, Long internationalKeyId, RequestContext context, List<International> insertInternationals) {
        if (languageId != null && internationalKeyId != null) {
            String postTranslation = model.getPostTranslation();
            International international = new International();
            international.setId(idGenerator.generate());
            international.setInternationalKeyId(internationalKeyId);
            international.setLanguageId(languageId);
            international.setPostTranslation(model.getPostTranslation());
            international.setPreTranslation(model.getPreTranslation());
            international.setTranslateRemark(model.getTranslationRemark());
            international.setInternationalKey(model.getKey());
            international.setType(type);
            international.setDeleted(0);
            international.setCreateById(context.getAccountId());
            international.setCreateTime(new Date());
            if (postTranslation == null) {
                postTranslation = "";
            }
            international.setPostTranslation(postTranslation);
            insertInternationals.add(international);
        } else {
            log.error("languageId或internationalKeyId值为空，传参：{}");
        }
    }

    /**
     * 获取需要保存的value
     *
     * @param model                valueId  翻译值得id
     * @param context
     * @param updateInternationals
     */
    private void buildUpdateInternational(InternationalImport model, Long valueId, RequestContext context, List<International> updateInternationals) {
        if (valueId != null) {
            String postTranslation = model.getPostTranslation();
            International international = new International();
            international.setId(valueId);
            international.setUpdateById(context.getAccountId());
            international.setUpdateTime(new Date());
            if (postTranslation == null) {
                postTranslation = "";
            }
            international.setPostTranslation(postTranslation);
            international.setPreTranslation(model.getPreTranslation());
            international.setTranslateRemark(model.getTranslationRemark());
            updateInternationals.add(international);
        } else {
            log.error("valueId值为空，传参：{}", JSON.toJSONString(model));
        }
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public InternationalVO updateInternational(InternationalVO internationalVO) {

        International international1 = this.baseMapper.selectById(internationalVO.getId());
        if (international1 == null) {
            log.error("无效的id!!!");
            return null;
        }
        RequestContext context = ContextHolder.get();
        Date date = new Date();
        String preTranslation = internationalVO.getPreTranslation();
        String remark = internationalVO.getTranslateRemark();
        if (StringUtils.isNotBlank(preTranslation) || StringUtils.isNotBlank(remark)) {
            internationalVO.setInternationalKeyId(international1.getInternationalKeyId());
            Integer update = internationalKeyService.update(internationalVO);
            if (update > 0) {
                asynUpdate(internationalVO.getTranslateRemark(),internationalVO.getPreTranslation(),international1.getInternationalKeyId(),date,context);
            }
        }
        if (internationalVO.getPostTranslation() != null) {
            International international = new International();
            international.setPostTranslation(internationalVO.getPostTranslation());
            international.setTranslateRemark(internationalVO.getTranslateRemark());
            international.setPreTranslation(internationalVO.getPreTranslation());
            international.setId(internationalVO.getId());
            international.setUpdateTime(date);
            international.setUpdateById(context.getAccountId());
            boolean result = this.updateById(international);
            log.info("修改该国际化的结果：{}", result);
            if (result) {
                SiteDic siteDic = siteDicService.selectById(international1.getLanguageId());
                String redisKey = CacheNamespace.SITE_LANGUAGE_INTERNATIONAL_WORD + international1.getType();
                String[] item = new String[]{siteDic.getCode()};
                redisCache.hdel(redisKey, item);
            }
        }
        return internationalVO;
    }

    /**
     * 异步更新备注和中文字段
     * @param translateRemark
     * @param preTranslation
     */
    private void asynUpdate(String translateRemark,String preTranslation, Long internationalKeyId,Date date,RequestContext context) {
        taskExecutor.asynExecute(new AbstractTaskHandler() {
            @Override
            public void handle() {
                International international = new International();
                international.setTranslateRemark(translateRemark);
                international.setPreTranslation(preTranslation);
                international.setUpdateTime(date);
                international.setUpdateById(context.getAccountId());
                EntityWrapper wrapper = new EntityWrapper();
                wrapper.eq("deleted",0).eq("international_key_id",internationalKeyId);
                internationalService.update(international,wrapper);
            }
        });

    }

    @Override
    public Map<String, Long> getValueMap(Long languageId) {
        Map<String, Long> valueMap = null;
        International international = new International();
        international.setLanguageId(languageId);
        international.setDeleted(0);
        List<International> internationals = this.baseMapper.selectList(new EntityWrapper<>(international));
        String key = null;
        if (CollectionUtils.isNotEmpty(internationals)) {
            valueMap = new HashMap<>(internationals.size());
            for (International a : internationals) {
                key = a.getInternationalKeyId() + "_" + a.getLanguageId();
                valueMap.put(key, a.getId());
            }
        }
        return valueMap;
    }

    /**
     * 异步更新其余语种
     *
     * @param type
     * @param languageId
     */
    private void insertOtherLanguage(Integer type, Long languageId, RequestContext context) {
        taskExecutor.asynExecute(new AbstractTaskHandler() {
            @Override
            public void handle() {
                //获取国际化的keyIds
                Map<Long, InternationalKey> keyIdMap = internationalKeyService.getKeyIdMap(type, null);
                //获取所有语种id
                SiteDic siteDic = new SiteDic();
                siteDic.setParentId(82L);
                Map<Long, SiteDic> siteDicMap = siteDicService.selectSiteDicMap(siteDic);
                //获取翻译的map
                Map<String, International> languageKeyIdMap = getLanguageKeyIdMap(type);
                Set<String> languageKeyIdSet = new HashSet<>();
                if (languageKeyIdMap != null) {
                    languageKeyIdSet = languageKeyIdMap.keySet();
                }
                //获取需要插入的数据
                List<International> insertInternationalList = new ArrayList<>();
                //需要清除缓存的code
                Set<String> codes = new HashSet<>();

                String key = null;
                for (Map.Entry<Long, SiteDic> siteDicEntry : siteDicMap.entrySet()) {
                    Long a = siteDicEntry.getKey();
                    if (a.equals(languageId)) {
                        //排除当前导入语种
                        continue;
                    }
                    for (Map.Entry<Long, InternationalKey> b : keyIdMap.entrySet()) {
                        key = b.getKey() + "_" + a;
                        InternationalKey value = b.getValue();
                            if (!languageKeyIdSet.contains(key)) {
                                InternationalImport model = new InternationalImport(value.getInternationalKey(), value.getPreTranslation(), null, value.getTranslateRemark());
                                buildInsertInternational(model, type, a, b.getKey(), context, insertInternationalList);
                                codes.add(siteDicEntry.getValue().getCode());
                            }
                    }
                }
                if (CollectionUtils.isNotEmpty(insertInternationalList)) {
                    internationalService.insertBatch(insertInternationalList);
                    String temKey = CacheNamespace.SITE_LANGUAGE_INTERNATIONAL_WORD + type;
                    redisCache.hdel(temKey, codes.toArray());
                }
            }
        });
    }

    /**
     * 获取<语种id_keyId,domain>
     *
     * @return
     * @param type
     */
    private Map<String, International> getLanguageKeyIdMap(Integer type) {
        International international = new International();
        international.setDeleted(0);
        international.setType(type);
        List<International> internationals = this.baseMapper.selectList(new EntityWrapper<>(international));
        if (CollectionUtils.isNotEmpty(internationals)) {
            Map<String, International> map = new HashMap<>(internationals.size());
            String key = null;
            for (International a:internationals){
                key = a.getInternationalKeyId() + "_" + a.getLanguageId();
                map.put(key, a);
            }
            return map;
        }
        return null;
    }
}
