package com.yizhi.site.application.service.impl;

import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.domain.TrInformationReadNumber;
import com.yizhi.site.application.mapper.TrInformationReadNumberMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.site.application.service.ITrInformationReadNumberService;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

/**
 * <p>
 * 资讯阅读次数统计 服务实现类
 * </p>
 *
 * @author lilingye  
 * @since 2018-06-25
 */
@Service
@Log4j2
public class TrInformationReadNumberServiceImpl extends ServiceImpl<TrInformationReadNumberMapper, TrInformationReadNumber> implements ITrInformationReadNumberService {

    @Autowired
    private IdGenerator idGenerator;
    
    @Autowired
    TrInformationReadNumberMapper informationReadNumberMapper;

    /**
     * 获取阅读次数d
     * @param informationId 咨询id
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Integer getInformationReadCount(Long informationId) {

        RequestContext context = ContextHolder.get();
        // 声明实体
        TrInformationReadNumber trInformationReadNumber = new TrInformationReadNumber();
        // 组装实体
        trInformationReadNumber.setId(idGenerator.generate());
        trInformationReadNumber.setInformationId(informationId);
        trInformationReadNumber.setSiteId(context.getSiteId());
        trInformationReadNumber.setCreateTime(new Date());
        trInformationReadNumber.setCreateById(context.getAccountId());
        this.insert(trInformationReadNumber);

        TrInformationReadNumber informationReadNumber = new TrInformationReadNumber();

        informationReadNumber.setInformationId(informationId);

        Integer readCount = this.selectCount(QueryUtil.condition(informationReadNumber));
        log.info("阅读次数："+readCount);

        return readCount;
    }

	@Override
	public Integer getInformationReadCountPc(Long informationId) {
		// TODO Auto-generated method stub
		 TrInformationReadNumber informationReadNumber = new TrInformationReadNumber();
	     informationReadNumber.setInformationId(informationId);
	     Integer num=this.selectCount(QueryUtil.condition(informationReadNumber));
	     return  num==null?0:num;
	}

	@Override
	public Integer getInformationReadDistinctCount(Long informationId) {
		return informationReadNumberMapper.getInformationReadDistinctCount(informationId);
	}
}
