package com.yizhi.site.application.service.impl;

import com.yizhi.site.application.domain.TrPortalLookNum;
import com.yizhi.site.application.mapper.TrPortalLookNumMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.site.application.service.ITrPortalLookNumService;
import com.yizhi.site.application.service.PortalHomeService;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author wfd123
 * @since 2019-02-22
 */
@Service
public class TrPortalLookNumServiceImpl extends ServiceImpl<TrPortalLookNumMapper, TrPortalLookNum> implements ITrPortalLookNumService {

	
	@Autowired 
	private TrPortalLookNumMapper trPortalLookNumMapper;

	@Autowired	
	private IdGenerator idGenerator;
	
	@Autowired
	private PortalHomeService portalHomeService;
	
	@Override
	public TrPortalLookNum listApiPortalPCPortalLookNum(Long siteId, Integer terminalType) {
		// TODO Auto-generated method stub
		return trPortalLookNumMapper.listApiPortalPCPortalLookNum(siteId, terminalType);
	}

	@Override
	public TrPortalLookNum lookNumSelectPc(Long terminalId) {
		// TODO Auto-generated method stub
		TrPortalLookNum tpln=trPortalLookNumMapper.lookNumSelectPc(terminalId);
		if(tpln!=null) {
			 return tpln;
		}
		else {
			Long homeId=portalHomeService.getHomeId(terminalId);
			tpln=new TrPortalLookNum();
			tpln.setId(idGenerator.generate());
			tpln.setDefaultNum(0);
			tpln.setDisplay(0);
			tpln.setHomeId(homeId);
			this.insert(tpln);
			return tpln;
		}
	}

	@Override
	public TrPortalLookNum lookNumSetPc(TrPortalLookNum trPortalLookNum) {
		// TODO Auto-generated method stub
		//先查询再输出
		if(trPortalLookNum!=null &&(trPortalLookNum.getDisplay()!=null || trPortalLookNum.getDefaultNum()!=null)) {
			this.updateById(trPortalLookNum);
		}
		
		return this.selectById(trPortalLookNum);
	}
}
