package com.yizhi.site.application.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * 门户枚举字段
 * @date 2019年5月9日
 * @author lly
 */
public enum PortalEnum {

    ZERO,ONE,TWO,THREE,FOUR,FIVE,SIX,SEVEN,EIGHT,NINE,TEN,TWELVE(12),FIFTEEN(15);

    private int value;

    PortalEnum() {
    }

    PortalEnum(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    @JsonCreator
    public static PortalEnum forValue(int ordinal) {
        return PortalEnum.values()[ordinal];
    }

    @JsonValue
    public int toValue() {
        return this.ordinal();
    }

}
