package com.yizhi.site.application.feign;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.site.application.vo.domain.InformationVo;
import com.yizhi.site.application.vo.site.IdOneVO;
import com.yizhi.site.application.vo.site.InfomationParamReleaseVO;
import com.yizhi.site.application.vo.site.InfomationParamVO;
import com.yizhi.site.application.vo.site.ParamVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name = "portal", contextId = "InformationManageFeignClients")
public interface InformationManageFeignClients {

	/**
	 * 查看资讯
	 */
	@PostMapping("/manage/site/classify/info/list")
	public Page<InformationVo> list(@RequestBody InfomationParamVO vo);

	@ApiOperation(value = "查询发布的新闻列表")
	@PostMapping("/manage/site/classify/info/release/list")
	public Page<InformationVo> releaseList(@RequestBody InfomationParamReleaseVO vo);

	/**
	 * 保存资料分类
	 */
	@PostMapping("/manage/site/classify/info/insert")
	public Long insert(@RequestBody InformationVo information);

	/**
	 * 修改资料分类
	 */
	@PostMapping("/manage/site/classify/info/update")
	public Boolean update(@RequestBody InformationVo information);

	/**
	 * 删除资讯
	 */
	@PostMapping("/manage/site/classify/info/delete")
	Boolean deleteById(@RequestBody IdOneVO vo);

	/**
	 * 资讯发布
	 */
	@PostMapping("/manage/site/classify/info/releases")
	boolean releases(@RequestBody ParamVO vo);

	/**
	 * 资讯取消发布
	 */
	@PostMapping("/manage/site/classify/info/unreleases")
	boolean unreleases(@RequestBody ParamVO vo);

	/**
	 * 资讯预览
	 */
	@GetMapping(value = "/manage/site/classify/info/view/{id}")
	InformationVo informationView(@RequestParam(name = "id") Long id);

	/**
	 * 置顶
	 */
	@PostMapping("/manage/site/classify/info/top")
	Boolean top(@RequestBody IdOneVO vo);

	/**
	 * 搜索资讯
	 */
	@GetMapping(value = "/manage/site/classify/info/listbyName")
	List<InformationVo> listbyName(@RequestParam(name = "name") String name, @RequestParam(name = "siteId") Long siteId);

    /**
     * 新闻资讯公告上架
     * @param id 新闻公告id
     * @return
     */
    @GetMapping("/manage/site/classify/info/upInfomation")
    public boolean upInfomation(@RequestParam(value = "id") Long id);
	/**
	 * 新闻资讯pdf转图片需要
	 * @return
	 */
	@PostMapping(value = "/manage/site/classify/info/updateContent")
	public boolean updateContent(@RequestBody InformationVo information);

	@GetMapping(value = "/manage/site/classify/info/listbyIds")
	List<InformationVo> listbyIds(@RequestParam(name = "idList")List<Long> idList);
}
