package com.yizhi.site.application.feign.api;

import com.yizhi.site.application.vo.domain.EventTrackVo;
import com.yizhi.site.application.vo.site.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * com.yizhi.site.application.feign.api
 *
 * @author yanglang
 * @create 2025-01-14 11:00:10
 */
@FeignClient(name = "portal", contextId = "EventTrackApiClients")
public interface EventTrackApiClients {
    @GetMapping("/api/eventTrack/addEvent")
    void addEvent(@RequestParam("type") String type, @RequestParam("businessId") Long businessId);

    @GetMapping("/api/eventTrack/getTodayNum")
    EventTrackDayNumVo getTodayNum(@RequestParam(value = "date",required = false)  String date, @RequestParam(value = "types",required = false) Integer types);

    @GetMapping("/api/eventTrack/getNumByType")
    DayNumVo getNumByType(@RequestParam(value = "date",required = false) String date, @RequestParam("types")List<Integer> types);

    @GetMapping("/api/eventTrack/queryNumByType")
    List<EventTrackTypeNumVo> queryNumByType(@RequestParam(value = "date",required = false) String date, @RequestParam("types")List<Integer> types,
                                             @RequestParam(value = "subName",required = false) String subName);

    @GetMapping("/api/eventTrack/queryDeptByType")
    List<EventTrackDeptNumVo> queryDeptByType(@RequestParam(value = "date",required = false) String date, @RequestParam("types")List<Integer> types);

    @GetMapping("/api/eventTrack/queryTgNumByDept")
    List<EventTrackDeptNumVo> queryTgNumByDept(@RequestParam(value = "typeId", required = false)Long typeId);

    @GetMapping("/api/eventTrack/queryListByType")
    List<EventTrackVo> queryListByType(@RequestParam("type") Integer type, @RequestParam("accountId") Long accountId);

    @GetMapping("/api/eventTrack/getExamTotal")
    Integer getExamTotal(@RequestParam("subType") String subType,@RequestParam("year") String year);

    @GetMapping("/api/eventTrack/queryExamNum")
    List<EventTrackDeptNumVo> queryExamNum();

    @GetMapping("/api/eventTrack/queryRankList")
    List<EventTrackRankListVo> queryRankList(@RequestParam("date") String date, @RequestParam("type") String type);
}
