package com.yizhi.site.application.vo.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@ApiModel(value = "DataClassificationEntityVo", description = "资讯分类")
@Data
public class DataClassificationVo {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "资料分类ID主键")
    private Long id;
    
    @ApiModelProperty(value = "分类名称")
    private String name;

    @ApiModelProperty(value = "分类名称：title")
    private String title;
    
    @ApiModelProperty(value = "分类描述")
    private String description;
    
    @ApiModelProperty(value = "上级分类")
    private Long parentId;
    
    @ApiModelProperty(value = "排序")
    private Long sort;
    
    @ApiModelProperty(value = "状态,0: 删除 1:未删除")
    private Integer state;
    
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    
    @ApiModelProperty(value = "创建人")
    private Long createById;
    
    @ApiModelProperty(value = "创建人姓名")
    private String createByName;
    
    @ApiModelProperty(value = "修改时间")
    private Date updateTime;
    
    @ApiModelProperty(value = "修改人")
    private Long updateById;
    
    @ApiModelProperty(value = "修改人姓名")
    private String updateByName;
    
    @ApiModelProperty(value = "站点ID")
    private Long siteId;
    
    @ApiModelProperty(value = "层级")
	private Integer level;
    
    @ApiModelProperty(value = "子新闻分类")
    private List<DataClassificationVo> childClassifyNews;

    @ApiModelProperty(value = "咨询文章信息")
    private List<InformationVo> informationVoList;

    @ApiModelProperty(value = "该分类下所有资讯的评论总数")
    private Integer commentNum;

    protected Serializable pkVal() {
        return this.id;
    }

    public String getTitle() {
        this.title = this.name;
        return title;
    }

    public void setTitle(String title) {
        this.name = title;
        this.title = title;
    }
}
