package com.yizhi.site.application.vo.site;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author lly
 * @date 2019-5-9
 */
@ApiModel(value = "PlateVO", description = "模板类型")
@Data

public class PlateVO {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "推荐/精选ID")
	private Long id;

	@ApiModelProperty(value = "模块ID")
	private Long templateId;

	@ApiModelProperty(value = "新闻ID")
	private Long newsId;
	
	@ApiModelProperty(value = "选择活动    推荐/精选  有")
	private Long selectActivity;
	
	@ApiModelProperty(value = "选择活动名称    推荐/精选  有")
	private String selectActivityName;
	
	@ApiModelProperty(value = "是否推荐    推荐/精选  有  0 不推荐  1 推荐")
	private Integer isRecommend;

	@ApiModelProperty(value = "id,  选择直播, 选择项目, 选择课程 有  推荐/精选 没有")
	private Long linkContent;
	
	@ApiModelProperty(value = "链接活动类型  //0 '课程'      1 '考试'             2  '调研'             3  '直播'             4  '投票'                5  '作业'              6  '证书'         7  '外部链接'      8  '报名'       9  '签到'       10  '线下课程' ")
	private Integer linkType;

    @ApiModelProperty(value = "课程编码")
    private String courseNo;
	
	@ApiModelProperty(value = "选择直播, 选择项目, 选择课程  名称")
	private String linkContentName;

	@ApiModelProperty(value = "缩略图, 0:使用内容图片, 1:使用新图片")
	private Integer thumbnail;

	@ApiModelProperty(value = "图片路径")

	private String imgPath;

	@ApiModelProperty(value = "说明")
	private String directions;

	@ApiModelProperty(value = "0: 删除  1: 未发布  2： 发布")
	private Integer state;


	
	@ApiModelProperty(value="排序规则")
	private Integer sort;
	

	protected Serializable pkVal() {
		return this.id;
	}
}
