package com.yizhi.site.application.vo.site;

import java.util.Date;

import com.baomidou.mybatisplus.annotations.TableField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value="PreviewNewsVO", description="预览新闻")
@Data
public class PreviewNewsVO {
	
	@ApiModelProperty(value = "主鍵")
    private Long id;
    
    @ApiModelProperty(value = "封面logo")
    @TableField("logo_path")
    private String logoPath;
    
    @ApiModelProperty(value = "编号")
    private String number;
    
    @ApiModelProperty(value = "文章名称")
    @TableField("file_name")
    private String fileName;
    
    @ApiModelProperty(value = "文章父类型  1： 新闻   2: 公告")
    private Long typeOne;
    
    @ApiModelProperty(value = "文章子类型")
    private Long typeTwo;
    
    @ApiModelProperty(value = "作者")
    private String author;
    
    @ApiModelProperty(value = "发布时间")
    private Date releaseTime;
    
    @ApiModelProperty(value = "内容")
    private String content;
    
    @ApiModelProperty(value = "原文链接")
    private String linkUrl;
    
    @ApiModelProperty(value = "自定义关键字")
    private String keyWords;
    
    @ApiModelProperty(value = "置顶状态, 0: 未置顶 1:置顶")
    private Integer isTop;

}
