package com.yizhi.site.application.vo.site;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * com.yizhi.site.application.vo.site
 *
 * @author yanglang
 * @create 2024-12-17 14:53:19
 */
@Data
@ApiModel(value="InfomationParamVO", description="查看投稿参数VO")
public class PublicationParamVO extends ContextVO {

    @ApiModelProperty(value="标题")
    private String fileName;

    @ApiModelProperty(value = "编号")
    private String number;

    @ApiModelProperty("作者")
    private String author;

    @ApiModelProperty(value="当前页")
    private Integer pageNo;

    @ApiModelProperty(value="每页的个数")
    private Integer pageSize;

    @ApiModelProperty(value="类型")
    private Long typeId;

    @ApiModelProperty(value="类型级别")
    private Long level;

    @ApiModelProperty(value = "创建人")
    private Long createById;

    @ApiModelProperty(value="发布时间的起点")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date start;

    @ApiModelProperty(value="发布时间的终点")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date end;

    private Long siteId;

    @ApiModelProperty(value = "状态 0 删除 1 草稿 2 待审核 3 待发布 4 已发布 5 不通过")
    private Integer state;


}
