package com.yizhi.site.application.controller;

import com.yizhi.site.application.constant.SiteConstant;
import com.yizhi.site.application.domain.Site;
import com.yizhi.site.application.service.SiteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.plugins.Page;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * <p>
 * 多站点管理，前端控制器
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@Api(tags = "管理端-多站点管理", description = "多站点管理")
@RestController
@RequestMapping("/sites")
public class MoreSiteManageController {

	@Autowired
    SiteService siteService;

	/**
	 * 多站点管理
	 * 
	 * @param page
	 * @return
	 */
	@GetMapping("/list")
	@ApiOperation(value = "分页列表", notes = "查询多站点的")
	public Page<Site> listPage(@RequestBody Page<Site> page) {
		return siteService.listPage(page);
	}

	/**
	 * 插入
	 * 
	 * @param site
	 *            站点实体类
	 * @return
	 */
	@ApiOperation(value = "插入", notes = "插入")
	@PostMapping("/insert")
	public Boolean insertDetail(@RequestBody Site site) {
		return siteService.insertDetail(site);
	}

	/**
	 * 编辑站点
	 * 
	 * @param site
	 *            站点实体类
	 * @return
	 */
	@ApiOperation(value = "编辑站点", notes = "编辑站点")
	@PostMapping("/update")
	public Boolean updateById(@RequestBody Site site) {
		return siteService.updateById(site);
	}

	/**
	 * 站点查看
	 * 
	 * @param id
	 *            主键
	 * @return
	 */
	@ApiOperation(value = "站点查看", notes = "站点查看")
	@GetMapping("/view")
	public Site find(@RequestParam Long id) {
		return siteService.selectById(id);
	}

	/**
	 * 站点上架
	 * 
	 * @param id
	 *            主键
	 * @return
	 */
	@ApiOperation(value = "站点上架", notes = "站点上架")
	@PostMapping("/up")
	public Boolean siteUp(@RequestParam Long id) {
		Site site = new Site();
		site.setState(SiteConstant.FIRST);
		site.setId(id);
		return siteService.updateById(site);
	}

	/**
	 * 站点下架
	 * 
	 * @param id
	 *            主键
	 * @return
	 */
	@ApiOperation(value = "站点下架", notes = "站点下架")
	@PostMapping("/down")
	public Boolean siteDown(@RequestParam Long id) {
		Site site = new Site();
		site.setState(SiteConstant.ZERO);
		site.setId(id);
		return siteService.updateById(site);
	}

	/**
	 * 站点设置管理人员
	 * 
	 * @param siteId
	 * @param accountId
	 * @return
	 */
	@ApiOperation(value = "站点设置管理人员", notes = "站点设置管理人员")
	@PostMapping("/user/manage")
	public Boolean setManagePersonnal(@RequestParam Long siteId, @RequestParam Long accountId) {
		return siteService.insertSiteManageStaff(siteId, accountId);
	}
}
