package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 *
 * </p>
 *
 * @author liang123
 * @since 2018-12-21
 */
@Data
@Api(tags = "PageFooterEntityVo", description = "底页编辑")
@TableName("page_footer")
public class PageFooter extends Model<PageFooter> {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "主键id")
    private Long id;

    @ApiModelProperty(value = "0 默认页底  1 自定义页底")
    private Integer type;

    @ApiModelProperty(value = "首页id")
    @TableField("home_id")
    private Long homeId;

    @ApiModelProperty(value = "企业_ID")
    @TableField("company_id")
    private Long companyId;

    @ApiModelProperty(value = "站点_ID")
    @TableField("site_id")
    private Long siteId;

    @ApiModelProperty(value = "部门_ID")
    @TableField("org_id")
    private Long orgId;

    @ApiModelProperty(value = " 0  未删除  1 表示删除  (默认 0)")
    private Integer delete;

    @ApiModelProperty(value = "创建时间")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    @ApiModelProperty(value = "创建人id")
    @TableField(value = "create_by_id", fill = FieldFill.INSERT)
    private Long createById;

    @ApiModelProperty(value = "创建人姓名")
    @TableField(value = "create_by_name", fill = FieldFill.INSERT)
    private String createByName;

    @ApiModelProperty(value = "修改人id")
    @TableField(value = "update_by_id", fill = FieldFill.INSERT)
    private Long updateById;

    @ApiModelProperty(value = "修改人名")
    @TableField(value = "update_by_name", fill = FieldFill.INSERT)
    private String updateByName;

    @ApiModelProperty(value = "修改时间")
    @TableField(value = "update_time", fill = FieldFill.INSERT)
    private Date updateTime;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
