package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@ApiModel(value = "PortalImageEntityVo", description = "轮播项图片")
@Data
@TableName("tr_portal_image")
public class PortalImage extends Model<PortalImage> {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "主键")
	private Long id;

	@ApiModelProperty(value = "轮播图ID")
	@TableField("banner_id")
	private Long bannerId;

	@ApiModelProperty(value = "图片标题")
	@TableField("img_title")
	private String imgTitle;

	@ApiModelProperty(value = "存放图片路径")
	@TableField("banner_path")
	private String bannerPath;

	@ApiModelProperty(value = "跳转后的功能id, pc端外部链接")
	@TableField("link_url")
	private String linkUrl;
	
	
	//王飞达注释首页的类型, /首页的类型, 1：课程  2：考试   3：培训  4：外部链接 5:新闻 6:营销  8:首页不选类型时候（仅仅图片）   0:不是首页';2019-01-14
	@ApiModelProperty(value = "//首页的类型, 1：课程  2：考试   3：培训  4：外部链接 5:活动 6:调研 7:新闻 8:首页不选类型时候（仅仅图片）   0:不是首页")
	@TableField("home_type")
	private Integer homeType;
	
	@ApiModelProperty(value = "指定上架时间")
	@TableField("add_time")
	private Date addTime;

	@ApiModelProperty(value = "排序")
	private Integer sort;

	@ApiModelProperty(value = "0删除 1: 上架 2：下架")
	private Integer state;

	@ApiModelProperty(value = "创建时间")
	@TableField("create_time")
	private Date createTime;

	@ApiModelProperty(value = "创建人")
	@TableField("create_by_id")
	private Long createById;

	@ApiModelProperty(value = "创建人姓名")
	@TableField("create_by_name")
	private String createByName;

	@ApiModelProperty(value = "修改时间")
	@TableField("update_time")
	private Date updateTime;

	@ApiModelProperty(value = "修改人")
	@TableField("update_by_id")
	private Long updateById;

	@ApiModelProperty(value = "修改人姓名")
	@TableField("update_by_name")
	private String updateByName;
	
	@ApiModelProperty(value = "副标题")
	@TableField("img_title_sub")
	private String imgTitleSub;
	
	@ApiModelProperty(value = "图片来源")
	@TableField("img_source")
	private String imgSource;

	@Override
	protected Serializable pkVal() {
		return this.id;
	}
}
