package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@ApiModel(value = "ProtalContactEntityVo", description = "联系我们")
@Data
@TableName("tr_protal_contact")
public class ProtalContact extends Model<ProtalContact> {

    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty(value = "联系我们ID")
    private Long id;
    
    @ApiModelProperty(value = "首页ID")
    @TableField("home_id")
    private Long homeId;
    
    @ApiModelProperty(value = "站点ID")
    @TableField("site_id")
    private Long siteId;
    
    @ApiModelProperty(value = "平台介绍")
    @TableField("platform_info")
    private String platformInfo;
    
    @ApiModelProperty(value = "浏览建议")
    @TableField("scan_suggest")
    private String scanSuggest;
    
    @ApiModelProperty(value = "联系电话")
    @TableField("contact_tel")
    private String contactTel;
    
    @ApiModelProperty(value = "客服电话")
    @TableField("consumer_tel")
    private String consumerTel;
    
    @ApiModelProperty(value = "微信下载")
    @TableField("wechat_path")
    private String wechatPath;
    
    @ApiModelProperty(value = "IOS下载")
    @TableField("ios_path")
    private String iosPath;
    
    @ApiModelProperty(value = "安卓下载")
    @TableField("android_path")
    private String androidPath;
    
    @ApiModelProperty(value = "0:删除， 1：未发布 2：发布")
    private Integer state;
    
    @ApiModelProperty(value = "创建时间")
    @TableField("create_time")
    private Date createTime;
    
    @ApiModelProperty(value = "创建人")
    @TableField("create_by_id")
    private Long createById;
    
    @ApiModelProperty(value = "创建姓名")
    @TableField("create_by_name")
    private String createByName;
    
    @ApiModelProperty(value = "更新时间")
    @TableField("update_time")
    private Date updateTime;
    
    @ApiModelProperty(value = "更新人")
    @TableField("update_by_id")
    private Long updateById;
    
    @ApiModelProperty(value = "更新姓名")
    @TableField("update_by_name")
    private String updateByName;
    
    @ApiModelProperty(value = "备用1")
    private String spare1;
    
    @ApiModelProperty(value = "客服邮箱")
    @TableField("consumer_email")
    private String consumerEmail;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }
}
