package com.yizhi.site.application.mapper;

import java.util.Date;
import java.util.List;

import com.yizhi.site.application.domain.ProtalPlate;
import com.yizhi.site.application.vo.site.PortalPlateVO;
import org.apache.ibatis.annotations.Param;

import com.baomidou.mybatisplus.mapper.BaseMapper;

/**
 * <p>
 *  Mapper 接口
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
public interface ProtalPlateMapper extends BaseMapper<ProtalPlate> {

	void deleteNews(Long templateId);
	
	
	/**
	 * --------------分隔符-------------------
	 */
	void updateStateByTemplateId(@Param("templateId")Long templateId,@Param("accountId")Long accountId,@Param("accountName")String accountName,@Param("updateDate")Date updateDate);

	
	List<Long>	templateContentViewByTerminalIdAndModuleType(@Param("terminalId")Long terminalId,@Param("moduleType") Integer moduleType);

	 Integer maxSort(@Param("templateId")Long templateId);

    /**
     *  查询列表
     * @param templateId
     * @return
     */
	 List<PortalPlateVO> getPlateVOList(@Param("templateId") Long templateId);

    /**
     * 根据id获取当前的列表
     * @param id
     * @return
     */
	 List<ProtalPlate> getPlateListById(@Param("id") Long id);

    /**
     * 查询首页配置的模块的列表
     * @param terminalName
     * @param siteId
     * @param moduleType
     * @return
     */
	 List<Long> selectHomeConfigList(
	         @Param("terminalName") String terminalName,
	         @Param("siteId") Long siteId,
	         @Param("moduleType") int moduleType
                                     );
	
}
