package com.yizhi.site.application.service;

import java.util.List;

import com.baomidou.mybatisplus.service.IService;
import com.yizhi.site.application.domain.PortalNavigate;
import com.yizhi.site.application.vo.site.ApiPortalPCLink;
import com.yizhi.site.application.vo.site.NavigateListVO;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
public interface PortalNavigateService extends IService<PortalNavigate> {

	List<NavigateListVO> navigateList(Long homeId, Integer display);

	boolean copyNavigate(Long sourceId, Long targetId);

    /**
     * 获取参数列表
     * @param homeId
     * @param sourceSort
     * @param targetSort
     * @return
     */
    List<PortalNavigate> getNavigates(Long homeId, Integer sourceSort, Integer targetSort );

    
    
    /**
     * 导航栏1 修改和新增
     * @param vo
     * @return
     */
    PortalNavigate updateAndInsertNavigatePc(NavigateListVO vo);
    
    
    
    /**
     * 查看链接
     * @param terminalId
     * @param pcType
     * @return
     */
    List<PortalNavigate> getRelationListLink(Long terminalId,Integer pcType);
    
    
    
    /**
     * 删除链接
     * @param id
     * @return
     */
    Boolean deleteNavigatePc(Long id);
    
    
    Boolean updateSortNavigatePc(Long id,Integer isDown);
    
    
    /**
     * 导航栏2是都显示
     * @param display
     * @return
     */
    Boolean navigateUpdateDisplay(Long terminalId,Integer display);
    
    Integer navigateViewDisplay(Long terminalId);
    
    List<ApiPortalPCLink> listApiPortalPCLinkUp(Long siteId, Integer terminalType);
    
    List<ApiPortalPCLink> listApiPortalPCLinkDown(Long siteId, Integer terminalType);

    /**
     * 获取导航列表
     * @param homeId
     * @param display
     * @date 2019-2-26
     * @return
     */
    List<NavigateListVO> getNavigateList(Long homeId, Integer display);
    /**
     * 获取全部导航列表
     * @param homeId
     * @date 2019-2-26
     * @return
     */
    List<NavigateListVO> getNavigateList(Long homeId);
    /**
     * 根据站点id 获取导航是否关联
     * @param siteId 站点id
     * @param relationId 关联id
     * @return
     */
    List<PortalNavigate> getNavigateListByRelationId(Long siteId,Long relationId);
    
}
