package com.yizhi.site.application.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.domain.DataClassification;
import com.yizhi.site.application.domain.EventTrack;
import com.yizhi.site.application.domain.Publication;
import com.yizhi.site.application.mapper.EventTrackMapper;
import com.yizhi.site.application.service.DataClassificationService;
import com.yizhi.site.application.service.EventTrackService;
import com.yizhi.site.application.service.PublicationService;
import com.yizhi.site.application.vo.domain.EventTrackVo;
import com.yizhi.site.application.vo.site.*;
import com.yizhi.system.application.feign.DictionaryFeignClients;
import com.yizhi.system.application.vo.domain.Dictionary;
import com.yizhi.training.application.feign.LeaveWordClient;
import com.yizhi.training.application.vo.domain.AuthzUserGroupVo;
import com.yizhi.util.application.date.DateUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

/**
 * com.yizhi.site.application.service.impl
 *
 * @author yanglang
 * @create 2025-01-14 10:15:57
 */
@Service
public class EventTrackServiceImpl extends ServiceImpl<EventTrackMapper, EventTrack> implements EventTrackService {
    private static final Logger logger= LoggerFactory.getLogger(EventTrackServiceImpl.class);

    @Autowired
    private DictionaryFeignClients dictionaryFeignClients;

    @Autowired
    private LeaveWordClient leaveWordClient;

    @Autowired
    private DataClassificationService dataClassificationService;

    @Autowired
    private PublicationService publicationService;

    @Autowired
    IdGenerator idGenerator;

    @Override
    public void addEvent(String type,Long businessId){
        logger.info("新增埋点{},{}",type,businessId);
        RequestContext context = ContextHolder.get();
        Long userId = context.getAccountId();
        if(Objects.equals(type,"event_login") || Objects.equals(type,"open_index")){
            userId = businessId;
            ContextHolder.get().setAccountId(userId);
        }
        if(Objects.equals(type,"event_my_publication")){
            Publication publication = publicationService.publicationView(businessId);
        }
        EventTrack eventTrack = new EventTrack();
        if(businessId!=null){
            DataClassification dataClassification = dataClassificationService.selectById(businessId);
            if(dataClassification!=null){
                eventTrack.setRemark1(dataClassification.getName());
            }
        }
        Date toDay = new Date();
        eventTrack.setBusinessId(businessId);
        eventTrack.setCreateById(userId);
        eventTrack.setCreateByName(context.getAccountName());
        eventTrack.setCreateTime(toDay);
        eventTrack.setUpdateById(userId);
        eventTrack.setUpdateByName(context.getAccountName());
        eventTrack.setUpdateTime(toDay);
        AuthzUserGroupVo authzUserGroupVo = leaveWordClient.getAuthzUserGroup(userId);
        if(authzUserGroupVo!=null){
            eventTrack.setDeptId(authzUserGroupVo.getId());
            eventTrack.setDeptName(authzUserGroupVo.getName());
        }
        String tp;
        if(type.startsWith("event_tp_comment_")) {
            //保存评论业务类型
            eventTrack.setRemark2(type.substring(type.lastIndexOf("_") + 1, type.length()));
            tp = type.substring(0, type.lastIndexOf("_"));
        } else {
            tp = type;
        }

        String key = "event_track_type";
        List<Dictionary> dictionaryList = dictionaryFeignClients.listChildDictionary(key,false,1);
        if(CollUtil.isNotEmpty(dictionaryList)){
            Optional<Dictionary> optional = dictionaryList.stream().filter(d-> Objects.equals(d.getCode(),tp)).findFirst();
            if(optional!=null&&optional.isPresent()){
                Dictionary dictionary = optional.get();
                eventTrack.setSubType(dictionary.getCnName());
                eventTrack.setType(Integer.valueOf(dictionary.getValue()));
            }
        }
        if(Objects.equals(type,"event_login")){
            EntityWrapper<EventTrack> wrapper = new EntityWrapper<EventTrack>();
            wrapper.eq("business_id",userId);
            wrapper.eq("type",eventTrack.getType());
            wrapper.between("create_time", DateUtil.parse(DateUtil.toDay(toDay),"yyyy-MM-dd"),toDay);
            EventTrack track = this.selectOne(wrapper);
            if(track!=null&&track.getId()!=null){
                return;
            }
        }
        eventTrack.setId(idGenerator.generate());
        this.insert(eventTrack);
    }

    @Override
    public EventTrackDayNumVo getTodayNum(String date) {
        if(ObjectUtils.isEmpty(date)){
            date = DateUtil.toDay(new Date());
        }
        RequestContext context = ContextHolder.get();
        return this.baseMapper.getTodayNum(date,context.getSiteId());
    }


    @Override
    public Integer getNum(String typeStr,Long businessId){
        String key = "event_track_type";
        Integer type = 0;
        RequestContext context = ContextHolder.get();
        if(typeStr.indexOf("event_favorite_")>=0){
            return this.baseMapper.getFavoriteNum(businessId,context.getSiteId());
        } else if(typeStr.indexOf("event_comment_")>=0){
            return this.baseMapper.getCommentNum(businessId,context.getSiteId());
        }
        List<Dictionary> dictionaryList = dictionaryFeignClients.listChildDictionary(key,false,1);
        if(CollUtil.isNotEmpty(dictionaryList)){
            Optional<Dictionary> optional = dictionaryList.stream().filter(d-> Objects.equals(d.getCode(),typeStr)).findFirst();
            if(optional!=null&&optional.isPresent()){
                Dictionary dictionary = optional.get();
                type =Integer.valueOf(dictionary.getValue());
            }
        }
        if(type==0){
            return 0;
        }

        return this.baseMapper.getNum(type,businessId,context.getSiteId());
    }

    @Override
    public DayNumVo getNumByType(String date,List<Integer> types) {
        if(ObjectUtils.isEmpty(date)){
            date = "3";
        }
        RequestContext context = ContextHolder.get();
        if(CollectionUtil.isEmpty(types)){
            return new DayNumVo(){{setNum(0);setPreNum(0);}};
        }
        String dateString =getDateString(date);
        if(Objects.equals(types.get(0),5)){
            //return this.baseMapper.getTgNumByType(date,dateString,context.getSiteId()); //20250810按新需求注释，现统计党委和纪检信箱
            //月
            if(date.equals("2")){
                DayNumVo day7NumVo = new DayNumVo();
                //查询本、上月
                dateString = dateString + "-01 00:00:00";
                DayNumVo dayNumVo = this.baseMapper.getMailTgNumByType(date,dateString,context.getSiteId(), null, null);
                day7NumVo.setNum(dayNumVo.getNum());
                day7NumVo.setPreNum(dayNumVo.getPreNum());

                //查询第3、第4月
                Date curDate = DateUtil.parse(dateString, "yyyy-MM-dd");
                curDate = DateUtil.getFirstDayOfMonth(DateUtil.addDay(curDate, -1));
                curDate = DateUtil.getFirstDayOfMonth(DateUtil.addDay(curDate, -1));
                dateString = DateUtil.format(curDate, "yyyy-MM-dd");
                dayNumVo = this.baseMapper.getMailTgNumByType(date,dateString,context.getSiteId(), null, null);
                day7NumVo.setThirdNum(dayNumVo.getNum());
                day7NumVo.setFourtNum(dayNumVo.getPreNum());

                //查询第5、第6月
                curDate = DateUtil.parse(dateString, "yyyy-MM-dd");
                curDate = DateUtil.getFirstDayOfMonth(DateUtil.addDay(curDate, -1));
                curDate = DateUtil.getFirstDayOfMonth(DateUtil.addDay(curDate, -1));
                dateString = DateUtil.format(curDate, "yyyy-MM-dd");
                dayNumVo = this.baseMapper.getMailTgNumByType(date,dateString,context.getSiteId(), null, null);
                day7NumVo.setFifthNum(dayNumVo.getNum());
                day7NumVo.setSixNum(dayNumVo.getPreNum());

                //查询第7月
                curDate = DateUtil.parse(dateString, "yyyy-MM-dd");
                curDate = DateUtil.getFirstDayOfMonth(DateUtil.addDay(curDate, -1));
                curDate = DateUtil.getFirstDayOfMonth(DateUtil.addDay(curDate, -1));
                dateString = DateUtil.format(curDate, "yyyy-MM-dd");
                dayNumVo = this.baseMapper.getMailTgNumByType(date,dateString,context.getSiteId(), null, null);
                day7NumVo.setSeventhNum(dayNumVo.getNum());

                return day7NumVo;
            }

            //日
            if(date.equals("3")){
                DayNumVo day7NumVo = new DayNumVo();
                //查询本、昨日
                DayNumVo dayNumVo = this.baseMapper.getMailTgNumByType(date,dateString,context.getSiteId(), null, null);
                day7NumVo.setNum(dayNumVo.getNum());
                day7NumVo.setPreNum(dayNumVo.getPreNum());

                //查询第3、第4日
                Date curDate = DateUtil.parse(dateString, "yyyy-MM-dd");
                curDate = DateUtil.addDay(curDate, -2);
                dateString = DateUtil.format(curDate, "yyyy-MM-dd");
                dayNumVo = this.baseMapper.getMailTgNumByType(date,dateString,context.getSiteId(), null, null);
                day7NumVo.setThirdNum(dayNumVo.getNum());
                day7NumVo.setFourtNum(dayNumVo.getPreNum());

                //查询第5、第6日
                curDate = DateUtil.addDay(curDate, -2);
                dateString = DateUtil.format(curDate, "yyyy-MM-dd");
                dayNumVo = this.baseMapper.getMailTgNumByType(date,dateString,context.getSiteId(), null, null);
                day7NumVo.setFifthNum(dayNumVo.getNum());
                day7NumVo.setSixNum(dayNumVo.getPreNum());

                //查询第7日
                curDate = DateUtil.addDay(curDate, -2);
                dateString = DateUtil.format(curDate, "yyyy-MM-dd");
                dayNumVo = this.baseMapper.getMailTgNumByType(date,dateString,context.getSiteId(), null, null);
                day7NumVo.setSeventhNum(dayNumVo.getNum());

                return day7NumVo;
            }

            //周
            if(date.equals("4")){
                DayNumVo day7NumVo = new DayNumVo();
                //查询本、上周
                Date curDate = new Date();
                String weekStartDate = DateUtil.format(DateUtil.getFirstDayOfWeek(curDate), "yyyy-MM-dd");
                String weekEndDate = DateUtil.format(curDate, "yyyy-MM-dd");
                DayNumVo dayNumVo = this.baseMapper.getMailTgNumByType(date,dateString,context.getSiteId(), weekStartDate, weekEndDate);
                day7NumVo.setNum(dayNumVo.getNum());
                day7NumVo.setPreNum(dayNumVo.getPreNum());

                //查询第3、第4周
                curDate = DateUtil.addDay(DateUtil.getFirstDayOfWeek(DateUtil.parse(weekStartDate + " 00:00:00", "yyyy-MM-dd HH:mm:ss")), -8);
                weekStartDate = DateUtil.format(DateUtil.getFirstDayOfWeek(curDate), "yyyy-MM-dd");
                weekEndDate = DateUtil.format(curDate, "yyyy-MM-dd");
                dayNumVo = this.baseMapper.getMailTgNumByType(date,dateString,context.getSiteId(), weekStartDate, weekEndDate);
                day7NumVo.setThirdNum(dayNumVo.getNum());
                day7NumVo.setFourtNum(dayNumVo.getPreNum());

                //查询第5、第6周
                curDate = DateUtil.addDay(DateUtil.getFirstDayOfWeek(DateUtil.parse(weekStartDate + " 00:00:00", "yyyy-MM-dd HH:mm:ss")), -8);
                weekStartDate = DateUtil.format(DateUtil.getFirstDayOfWeek(curDate), "yyyy-MM-dd");
                weekEndDate = DateUtil.format(curDate, "yyyy-MM-dd");
                dayNumVo = this.baseMapper.getMailTgNumByType(date,dateString,context.getSiteId(), weekStartDate, weekEndDate);
                day7NumVo.setFifthNum(dayNumVo.getNum());
                day7NumVo.setSixNum(dayNumVo.getPreNum());

                //查询第7周
                curDate = DateUtil.addDay(DateUtil.getFirstDayOfWeek(DateUtil.parse(weekStartDate + " 00:00:00", "yyyy-MM-dd HH:mm:ss")), -8);
                weekStartDate = DateUtil.format(DateUtil.getFirstDayOfWeek(curDate), "yyyy-MM-dd");
                weekEndDate = DateUtil.format(curDate, "yyyy-MM-dd");
                dayNumVo = this.baseMapper.getMailTgNumByType(date,dateString,context.getSiteId(), weekStartDate, weekEndDate);
                day7NumVo.setSeventhNum(dayNumVo.getNum());

                return day7NumVo;
            }

            return this.baseMapper.getMailTgNumByType(date,dateString,context.getSiteId(), null, null);
        }
        if(Objects.equals(types.get(0),8)){
            String year = DateUtil.toShortYear(new Date());
            DayNumVo dayNumVo = new DayNumVo();
            dayNumVo.setPreNum(this.baseMapper.getResearchTotal(year,context.getSiteId()));
            dayNumVo.setNum(this.baseMapper.getResearchJoinTotal(year,context.getSiteId()));
            return dayNumVo;
        }

        if(Objects.equals(types.get(0),1)){
            //月
            if(date.equals("2")){
                DayNumVo day7NumVo = new DayNumVo();
                //查询本、上月
                dateString = dateString + "-01 00:00:00";
                DayNumVo dayNumVo = this.baseMapper.getNumByType(date,dateString,types,context.getSiteId(), null, null);
                day7NumVo.setNum(dayNumVo.getNum());
                day7NumVo.setPreNum(dayNumVo.getPreNum());

                //查询第3、第4月
                Date curDate = DateUtil.parse(dateString, "yyyy-MM-dd");
                curDate = DateUtil.getFirstDayOfMonth(DateUtil.addDay(curDate, -1));
                curDate = DateUtil.getFirstDayOfMonth(DateUtil.addDay(curDate, -1));
                dateString = DateUtil.format(curDate, "yyyy-MM-dd");
                dayNumVo = this.baseMapper.getNumByType(date,dateString,types,context.getSiteId(), null, null);
                day7NumVo.setThirdNum(dayNumVo.getNum());
                day7NumVo.setFourtNum(dayNumVo.getPreNum());

                //查询第5、第6月
                curDate = DateUtil.parse(dateString, "yyyy-MM-dd");
                curDate = DateUtil.getFirstDayOfMonth(DateUtil.addDay(curDate, -1));
                curDate = DateUtil.getFirstDayOfMonth(DateUtil.addDay(curDate, -1));
                dateString = DateUtil.format(curDate, "yyyy-MM-dd");
                dayNumVo = this.baseMapper.getNumByType(date,dateString,types,context.getSiteId(), null, null);
                day7NumVo.setFifthNum(dayNumVo.getNum());
                day7NumVo.setSixNum(dayNumVo.getPreNum());

                //查询第7月
                curDate = DateUtil.parse(dateString, "yyyy-MM-dd");
                curDate = DateUtil.getFirstDayOfMonth(DateUtil.addDay(curDate, -1));
                curDate = DateUtil.getFirstDayOfMonth(DateUtil.addDay(curDate, -1));
                dateString = DateUtil.format(curDate, "yyyy-MM-dd");
                dayNumVo = this.baseMapper.getNumByType(date,dateString,types,context.getSiteId(), null, null);
                day7NumVo.setSeventhNum(dayNumVo.getNum());

                return day7NumVo;
            }

            //日
            if(date.equals("3")){
                DayNumVo day7NumVo = new DayNumVo();
                //查询本、昨日
                DayNumVo dayNumVo = this.baseMapper.getNumByType(date,dateString,types,context.getSiteId(), null, null);
                day7NumVo.setNum(dayNumVo.getNum());
                day7NumVo.setPreNum(dayNumVo.getPreNum());

                //查询第3、第4日
                Date curDate = DateUtil.parse(dateString, "yyyy-MM-dd");
                curDate = DateUtil.addDay(curDate, -2);
                dateString = DateUtil.format(curDate, "yyyy-MM-dd");
                dayNumVo = this.baseMapper.getNumByType(date,dateString,types,context.getSiteId(), null, null);
                day7NumVo.setThirdNum(dayNumVo.getNum());
                day7NumVo.setFourtNum(dayNumVo.getPreNum());

                //查询第5、第6日
                curDate = DateUtil.addDay(curDate, -2);
                dateString = DateUtil.format(curDate, "yyyy-MM-dd");
                dayNumVo = this.baseMapper.getNumByType(date,dateString,types,context.getSiteId(), null, null);
                day7NumVo.setFifthNum(dayNumVo.getNum());
                day7NumVo.setSixNum(dayNumVo.getPreNum());

                //查询第7日
                curDate = DateUtil.addDay(curDate, -2);
                dateString = DateUtil.format(curDate, "yyyy-MM-dd");
                dayNumVo = this.baseMapper.getNumByType(date,dateString,types,context.getSiteId(), null, null);
                day7NumVo.setSeventhNum(dayNumVo.getNum());

                return day7NumVo;
            }

            //周
            if(date.equals("4")){
                DayNumVo day7NumVo = new DayNumVo();
                //查询本、上周
                Date curDate = new Date();
                String weekStartDate = DateUtil.format(DateUtil.getFirstDayOfWeek(curDate), "yyyy-MM-dd");
                String weekEndDate = DateUtil.format(curDate, "yyyy-MM-dd");
                DayNumVo dayNumVo = this.baseMapper.getNumByType(date,dateString,types,context.getSiteId(), weekStartDate, weekEndDate);
                day7NumVo.setNum(dayNumVo.getNum());
                day7NumVo.setPreNum(dayNumVo.getPreNum());

                //查询第3、第4周
                curDate = DateUtil.addDay(DateUtil.getFirstDayOfWeek(DateUtil.parse(weekStartDate + " 00:00:00", "yyyy-MM-dd HH:mm:ss")), -8);
                weekStartDate = DateUtil.format(DateUtil.getFirstDayOfWeek(curDate), "yyyy-MM-dd");
                weekEndDate = DateUtil.format(curDate, "yyyy-MM-dd");
                dayNumVo = this.baseMapper.getNumByType(date,dateString,types,context.getSiteId(), weekStartDate, weekEndDate);
                day7NumVo.setThirdNum(dayNumVo.getNum());
                day7NumVo.setFourtNum(dayNumVo.getPreNum());

                //查询第5、第6周
                curDate = DateUtil.addDay(DateUtil.getFirstDayOfWeek(DateUtil.parse(weekStartDate + " 00:00:00", "yyyy-MM-dd HH:mm:ss")), -8);
                weekStartDate = DateUtil.format(DateUtil.getFirstDayOfWeek(curDate), "yyyy-MM-dd");
                weekEndDate = DateUtil.format(curDate, "yyyy-MM-dd");
                dayNumVo = this.baseMapper.getNumByType(date,dateString,types,context.getSiteId(), weekStartDate, weekEndDate);
                day7NumVo.setFifthNum(dayNumVo.getNum());
                day7NumVo.setSixNum(dayNumVo.getPreNum());

                //查询第7周
                curDate = DateUtil.addDay(DateUtil.getFirstDayOfWeek(DateUtil.parse(weekStartDate + " 00:00:00", "yyyy-MM-dd HH:mm:ss")), -8);
                weekStartDate = DateUtil.format(DateUtil.getFirstDayOfWeek(curDate), "yyyy-MM-dd");
                weekEndDate = DateUtil.format(curDate, "yyyy-MM-dd");
                dayNumVo = this.baseMapper.getNumByType(date,dateString,types,context.getSiteId(), weekStartDate, weekEndDate);
                day7NumVo.setSeventhNum(dayNumVo.getNum());

                return day7NumVo;
            }

            //年
            return this.baseMapper.getNumByType(date,dateString,types,context.getSiteId(), null, null);
        }

        return null;
    }

    private List<EventTrackTypeNumVo> queryNumByType(String date, Boolean isPre, List<Integer> types,String parentId) {
        logger.info("埋点统计行为统计入参date:{},isPre:{}, types:{}, parentId:{}", date, isPre, types, parentId);
        if(ObjectUtils.isEmpty(date)){
            date = "3";
        }
        String dateString = getDateString(date);
        RequestContext context = ContextHolder.get();
//        if(!ObjectUtils.isEmpty(subName)) {
//            String key = "event_track_type";
//            List<Dictionary> dictionaryList = dictionaryFeignClients.listChildDictionary(key, false, 1);
//            if (CollUtil.isNotEmpty(dictionaryList)) {
//                Optional<Dictionary> optional = dictionaryList.stream().filter(d -> Objects.equals(d.getValue(), "6")&&Objects.equals(d.getCnName(), subName)).findFirst();
//                if (optional != null && optional.isPresent()) {
//                    Dictionary dictionary = optional.get();
//                    id = Long.valueOf(dictionary.getCode());
//                }
//            }
//        }
        List<Long> subIdList = null;
        List<String> subNameList = null;
        if(StringUtils.isNotBlank(parentId)) {
            List<DataClassification> classificationList = dataClassificationService.getSon(Long.valueOf(parentId));
            if (CollectionUtil.isNotEmpty(classificationList)) {
                subIdList = classificationList.stream().map(DataClassification::getId).collect(Collectors.toList());
                subNameList = classificationList.stream().map(DataClassification::getName).collect(Collectors.toList());
            }
        }
        List<EventTrackTypeNumVo> eventTrackTypeNumVoList = null;
        logger.info("埋点统计行为统计入参date:{},isPre:{}, types:{}, dateString:{}, siteId:{}, subIdList:{}, subNameList:{}", date, isPre, types, dateString, context.getSiteId(), subIdList,subNameList);
        //一个type时表示获取的是互动量，否则则是取浏览量统计
        if(types.size() == 1){
            eventTrackTypeNumVoList = this.baseMapper.queryNumByTypeInformation(null,date,dateString,types,subIdList,context.getSiteId(), isPre);
        } else {
            eventTrackTypeNumVoList = this.baseMapper.queryNumByType(null,date,dateString,types,subNameList,context.getSiteId(), isPre);
        }
        logger.info("埋点统计行为统计查询结果:{}", JSONUtil.toJsonStr(eventTrackTypeNumVoList));
        if(CollectionUtil.isNotEmpty(subNameList)){
            List<EventTrackTypeNumVo> finalEventTrackTypeNumVoList = eventTrackTypeNumVoList;
            subNameList.stream().forEach(name->{
                EventTrackTypeNumVo eventTrackTypeNumVo = new EventTrackTypeNumVo();
                eventTrackTypeNumVo.setNum(0);
                eventTrackTypeNumVo.setSubType(name);
                if(CollectionUtil.isNotEmpty(finalEventTrackTypeNumVoList)){
                   Optional optional = finalEventTrackTypeNumVoList.stream().filter(e->Objects.equals(e.getSubType(),name)).findFirst();
                    if(optional==null||!optional.isPresent()){
                        finalEventTrackTypeNumVoList.add(eventTrackTypeNumVo);
                    }
                }else{
                    finalEventTrackTypeNumVoList.add(eventTrackTypeNumVo);
                }
            });
        }

        return eventTrackTypeNumVoList;
    }

    @Override
    public List<EventTrackTypeNumVo> queryNumByType(String date,List<Integer> types,String subName) {
        //统计本次量
        List<EventTrackTypeNumVo> eventTrackTypeNumVoList = queryNumByType(date, false, types, subName);
        Integer numTotal = 0;
        for(EventTrackTypeNumVo item : eventTrackTypeNumVoList){
            numTotal += item.getNum();
        }

        //统计上次量
        List<EventTrackTypeNumVo> preNumVoList = queryNumByType(date, true, types, subName);
        Integer preNumTotal = 0;
        for(EventTrackTypeNumVo item : preNumVoList){
            preNumTotal += item.getNum();
        }

        //赋值
        for(EventTrackTypeNumVo item : eventTrackTypeNumVoList){
            item.setNumTotal(numTotal);
            item.setPreNumTotal(preNumTotal);
        }

        return eventTrackTypeNumVoList;
    }

    @Override
    public List<EventTrackDeptNumVo> queryDeptByType(String date, List<Integer> types) {
        if(ObjectUtils.isEmpty(date)){
            date = "3";
        }
        String dateString =getDateString(date);
        String key = "event_track_type";
        RequestContext context = ContextHolder.get();
        List<Dictionary> dictionaryList = dictionaryFeignClients.listChildDictionary(key,false,1);
        Map<Integer,String> keyMap = Maps.newHashMap();
        if(CollUtil.isNotEmpty(dictionaryList)){
            dictionaryList.stream().forEach(d->{
                keyMap.put(Integer.valueOf(d.getValue()),d.getCnName());
            });

        }

        List<EventTrackDeptNumVo> eventTrackDeptNumVoList = this.baseMapper.queryGropByList(context.getSiteId());
        if(CollUtil.isNotEmpty(eventTrackDeptNumVoList)){
            String finalDate = date;
            eventTrackDeptNumVoList.stream().forEach(eventTrackDeptNumVo -> {
                List<EventTrackTypeNumVo> eventTrackTypeNumVoList = this.baseMapper.queryDeptByType(eventTrackDeptNumVo.getDeptId(), dateString,types,context.getSiteId());
                if(CollectionUtil.isNotEmpty(eventTrackTypeNumVoList)){
                    List<EventTrackTypeNumVo> voList = Lists.newArrayList();
                    eventTrackTypeNumVoList.stream().forEach(numVo->{
                       Optional<EventTrackTypeNumVo> optional= voList.stream().filter(v->Objects.equals(v.getType(),numVo.getType())).findFirst();
                       if(optional!=null&&optional.isPresent()){
                           EventTrackTypeNumVo vo = optional.get();
                           if(numVo.getNum()!=null) {
                               if(vo.getNum()!=null) {
                                   vo.setNum(numVo.getNum()+vo.getNum());
                               }else{
                                   vo.setNum(numVo.getNum());
                               }
                           }
                       }else{
                           if(numVo.getType()==13){
                               numVo.setSubType("评论总数");
                           }else{
                               numVo.setSubType(keyMap.get(numVo.getType()));
                           }
                           voList.add(numVo);
                       }
                    });
                    eventTrackDeptNumVo.setEventTrackTypeNumVoList(voList);
                }else {
                    eventTrackDeptNumVo.setEventTrackTypeNumVoList(eventTrackTypeNumVoList);
                }

                types.stream().forEach(t->{
                    EventTrackTypeNumVo vo = new EventTrackTypeNumVo();
                    vo.setType(t);
                    vo.setNum(0);
                    if(vo.getType()==13){
                        vo.setSubType("评论总数");
                    }else{
                        vo.setSubType(keyMap.get(vo.getType()));
                    }
                    if(CollectionUtil.isNotEmpty(eventTrackDeptNumVo.getEventTrackTypeNumVoList())) {
                        Optional<EventTrackTypeNumVo> optional = eventTrackDeptNumVo.getEventTrackTypeNumVoList().stream().filter(v -> Objects.equals(v.getType(), t)).findFirst();
                        if(!(optional!=null&&optional.isPresent())){
                            eventTrackDeptNumVo.getEventTrackTypeNumVoList().add(vo);
                        }
                    }else{
                        List<EventTrackTypeNumVo> voList = Lists.newArrayList();
                        voList.add(vo);
                        eventTrackDeptNumVo.setEventTrackTypeNumVoList(voList);
                    }
                });
            });
        }

        //统计参加活动
        Map<String, EventTrackTypeNumVo> trainningNum = this.baseMapper.queryTrainningNumBydeptId();
        for(EventTrackDeptNumVo item : eventTrackDeptNumVoList){
            EventTrackTypeNumVo eventTrackTypeNumVo = new EventTrackTypeNumVo();
            eventTrackTypeNumVo.setSubType("发起总数");
            eventTrackTypeNumVo.setType(99);
            int num = 0;
            if(trainningNum.get(item.getDeptId().toString())  != null ){
                num = trainningNum.get(item.getDeptId().toString()).getNum() == null ? 0 : trainningNum.get(item.getDeptId().toString()).getNum();
            }
            eventTrackTypeNumVo.setNum(num);
            item.getEventTrackTypeNumVoList().add(eventTrackTypeNumVo);
            //设置排序
            item.setEventTrackTypeNumVoList(item.getEventTrackTypeNumVoList().stream().sorted(Comparator.comparingInt(EventTrackTypeNumVo::getType)).collect(Collectors.toList()));
        }

        return eventTrackDeptNumVoList;
    }

    @Override
    public List<EventTrackDeptNumVo> queryTgNumByDept(Long typeId) {

        RequestContext context = ContextHolder.get();
        List<EventTrackDeptNumVo> eventTrackDeptNumVoList = this.baseMapper.queryGropByList(context.getSiteId());
        LocalDate today = LocalDate.now();
        List<Integer> recentMonths = new ArrayList<>();

        // 循环获取最近四个月的月份
        for (int i = 0; i < 4; i++) {
            Integer month = today.minusMonths(i).getMonthValue();
            recentMonths.add(month);
        }

        if(CollUtil.isNotEmpty(eventTrackDeptNumVoList)){
            eventTrackDeptNumVoList.stream().forEach(eventTrackDeptNumVo -> {
                List<EventTrackTypeNumVo> eventTrackTypeNumVoList = this.baseMapper.queryTgNumByDept(eventTrackDeptNumVo.getDeptName(),typeId,context.getSiteId());
//                if(CollectionUtil.isNotEmpty(eventTrackTypeNumVoList)){
//                    List<EventTrackTypeNumVo> voList = Lists.newArrayList();
//                    eventTrackTypeNumVoList.stream().forEach(numVo->{
//                        Optional<EventTrackTypeNumVo> optional= CollectionUtil.isEmpty(voList)?null:voList.stream().filter(v->Objects.equals(v.getType(),numVo.getType())).findFirst();
//                        if(optional!=null&&optional.isPresent()){
//                            EventTrackTypeNumVo vo = optional.get();
//                            if(numVo.getNum()!=null) {
//                                if(vo.getNum()!=null) {
//                                    vo.setNum(numVo.getNum()+vo.getNum());
//                                }else{
//                                    vo.setNum(numVo.getNum());
//                                }
//                            }
//                        }else{
//                            voList.add(numVo);
//                        }
//                    });
//                    eventTrackDeptNumVo.setEventTrackTypeNumVoList(voList);
//                }else {
//                    eventTrackDeptNumVo.setEventTrackTypeNumVoList(eventTrackTypeNumVoList);
//                }
                eventTrackDeptNumVo.setEventTrackTypeNumVoList(eventTrackTypeNumVoList);
                List<EventTrackTypeNumVo> newEventTrackTypeNumVoList = Lists.newArrayList();
                for(Integer month:recentMonths){
                    EventTrackTypeNumVo eventTrackTypeNumVo = new EventTrackTypeNumVo();
                    if(CollectionUtil.isEmpty(eventTrackDeptNumVo.getEventTrackTypeNumVoList())){
                        eventTrackTypeNumVo.setNum(0);
                        eventTrackTypeNumVo.setSubType(String.valueOf(month));
                    }else{
                       Optional<EventTrackTypeNumVo> optional = eventTrackDeptNumVo.getEventTrackTypeNumVoList().stream().filter(e->Objects.equals(Integer.valueOf(e.getSubType()),month)).findFirst();
                        if(optional!=null&&optional.isPresent()){
                            eventTrackTypeNumVo = optional.get();
                            eventTrackTypeNumVo.setSubType(Integer.valueOf(eventTrackTypeNumVo.getSubType()).toString());
                        }else{
                            eventTrackTypeNumVo.setNum(0);
                            eventTrackTypeNumVo.setSubType(String.valueOf(month));
                        }
                    }
                    newEventTrackTypeNumVoList.add(eventTrackTypeNumVo);
                }
                eventTrackDeptNumVo.setEventTrackTypeNumVoList(newEventTrackTypeNumVoList);
            });
        }


        return eventTrackDeptNumVoList;
    }

    @Override
    public List<EventTrackVo> queryListByType(Integer type, Long accountId) {
        EventTrack eventTrack = new EventTrack();
        eventTrack.setType(type);
        eventTrack.setCreateById(accountId);
        EntityWrapper entityWrapper = new EntityWrapper<>(eventTrack);
        List<String> orderList = Lists.newArrayList();
        orderList.add("create_time");
        entityWrapper.orderDesc(orderList);
        List<EventTrack> eventTrackList = this.selectList(entityWrapper);
        List<EventTrackVo> eventTrackVoList =Lists.newArrayList();
        if(CollectionUtil.isNotEmpty(eventTrackList)){
            eventTrackList.stream().forEach(e->{
                EventTrackVo vo = new EventTrackVo();
                BeanUtils.copyProperties(e,vo);
                eventTrackVoList.add(vo);
            });
        }
        return eventTrackVoList;
    }

    @Override
    public Integer getExamTotal(String subType,String year) {
        RequestContext context = ContextHolder.get();
        return this.baseMapper.getExamTotal(subType,year,context.getSiteId());
    }

    public String getDateString(String date) {
        String dateString = DateUtil.toDay(new Date());
        String[] dateArrays = dateString.split("-");
        if(Objects.equals(date,"1")){
            dateString = dateArrays[0];
        }
        if(Objects.equals(date,"2")){
            dateString = dateArrays[0]+"-"+dateArrays[1];
        }
        if(Objects.equals(date,"4")){
            Calendar calendar = Calendar.getInstance();
            int week = calendar.get(Calendar.WEEK_OF_YEAR);
            if(week==1){
                dateString = String.valueOf(Integer.valueOf(dateArrays[0])-1);
            }else{
                dateString = dateArrays[0];
            }
        }
        return dateString;
    }

    @Override
    public List<EventTrackDeptNumVo> queryExamNum() {
        //统计参加测试
        RequestContext context = ContextHolder.get();
        List<EventTrackDeptNumVo> eventTrackDeptNumVoList = this.baseMapper.queryGropByList(context.getSiteId());
        if (CollUtil.isNotEmpty(eventTrackDeptNumVoList)) {
            Map<String, EventTrackTypeNumVo> trainningNum = this.baseMapper.queryExamNumBydeptId();
            for (EventTrackDeptNumVo item : eventTrackDeptNumVoList) {
                EventTrackTypeNumVo eventTrackTypeNumVo = new EventTrackTypeNumVo();
                eventTrackTypeNumVo.setSubType("发起总数");
                eventTrackTypeNumVo.setType(99);
                int num = 0;
                if(trainningNum.get(item.getDeptId().toString())  != null ){
                    num = trainningNum.get(item.getDeptId().toString()).getNum() == null ? 0 : trainningNum.get(item.getDeptId().toString()).getNum();
                }
                eventTrackTypeNumVo.setNum(num);
                item.setEventTrackTypeNumVoList(new ArrayList<EventTrackTypeNumVo>());
                item.getEventTrackTypeNumVoList().add(eventTrackTypeNumVo);
            }
        }

        return eventTrackDeptNumVoList;
    }

    @Override
    public List<EventTrackRankListVo> queryRankList(String date, String type) {
        String dateString = getDateString(date);
        if(type.equals("1")) {
            //支部
            return this.baseMapper.queryRankListByDept(date, dateString);
        } else {
            //用户
            return this.baseMapper.queryRankListByUser(date, dateString);
        }
    }
}
