package com.yizhi.site.application.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.site.application.domain.SiteDic;
import com.yizhi.site.application.domain.SiteLanguage;
import com.yizhi.site.application.mapper.SiteDicMapper;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.site.application.service.ISiteDicService;
import com.yizhi.site.application.service.ISiteLanguageService;
import com.yizhi.core.application.task.AbstractTaskHandler;
import com.yizhi.core.application.task.TaskExecutor;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 门户字典表 服务实现类
 * </p>
 *
 * @author lingye
 * @since 2019-04-29
 */
@Service
@Log4j2
public class SiteDicServiceImpl extends ServiceImpl<SiteDicMapper, SiteDic> implements ISiteDicService {
    @Autowired
    private ISiteLanguageService siteLanguageService;
    @Autowired
    private TaskExecutor taskExecutor;

    public static final String LANGUAGE ="language";

    @Override
    public List<SiteDic> getSiteDicListByCode(String code) {
    	//从字典表中获取栏目
    	List<SiteDic> siteDics = this.baseMapper.getSiteDicListByCode(code);
    	
    	//管理端配置
    	if(code.equals("mb_navigate")){
    		//从新闻资讯获取栏目
        	List<SiteDic> dics = this.baseMapper.getSiteNewsDicListByCode();
        	if (CollectionUtils.isNotEmpty(dics) && CollectionUtils.isNotEmpty(siteDics)) {
        		//重新对字典表中取出的栏目Sort，放在新闻资讯栏目后面
        		int len = dics.size();
        		for(SiteDic item : siteDics) {
        			if(item.getSort() == null){
        				item.setSort(0);
        			}
        			item.setSort(item.getSort() + len);
        		}
        		
        		dics.addAll(siteDics);
        	}
            return dics;
    	}
    	
    	return siteDics;
    }

    @Override
    public SiteDic updateDicById(SiteDic siteDic) {
        String status = siteDic.getStatus();
        Long id = siteDic.getId();
        SiteDic siteDic1 = this.selectById(siteDic.getId());
        if (siteDic1 != null && "zh_CN".equals(siteDic1.getCode())) {
           siteDic.setStatus("1");
        }
        boolean resultFlag = this.updateById(siteDic);
        if (resultFlag){
            if (siteDic1.getParentId() == 82L) {
                taskExecutor.asynExecute(new AbstractTaskHandler() {
                    @Override
                    public void handle() {
                        updateSiteLanguage(status, id);
                    }
                });
                log.info("更新的结果：{}", resultFlag);
            }
        }
        return siteDic;
    }

    public void updateSiteLanguage(String status,Long languageId) {

        Integer state = 0;
        if ("1".equals(status)) {
            state = 0;
        } else if ("3".equals(status)) {
            state = 1;
        }
        SiteLanguage siteLanguage = new SiteLanguage();
        siteLanguage.setLanguageId(languageId);
        List<SiteLanguage> siteLanguages = siteLanguageService.selectList(QueryUtil.condition(siteLanguage));

        Integer finalState = state;
        siteLanguages = siteLanguages.stream().map(sl -> {
            sl.setDeleted(finalState);
            return sl;
        }).collect(Collectors.toList());
        boolean updateBatchById = siteLanguageService.updateBatchById(siteLanguages);
        log.info("批量修改站点结果：{}",updateBatchById);
    }

    /**
     * 查询字典
     *
     * @param siteDic
     * @return
     */
    @Override
    public SiteDic selectSiteDic(SiteDic siteDic) {
        EntityWrapper<SiteDic> condition = QueryUtil.condition(siteDic);
        return this.selectOne(condition);
    }


    @Override
    public Map<Long, SiteDic> selectSiteDicMap(SiteDic siteDic) {
        List<SiteDic> siteDics = this.selectList(QueryUtil.condition(siteDic));
        Map<Long, SiteDic> siteDicMap = null;
        if (CollectionUtils.isNotEmpty(siteDics)) {
            siteDicMap = siteDics.parallelStream().collect(Collectors.toMap(a -> a.getId(), a -> a));
        }
        return siteDicMap;
    }
}
