package com.yizhi.site.application.feign;

import com.yizhi.site.application.vo.domain.MyItemConfigVo;
import com.yizhi.site.application.vo.site.MyItemConfigVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name = "portal", contextId = "MyItemConfigManageClients")
public interface MyItemConfigManageClients {

    @PostMapping("/myItemConfig/manage/add")
    public Integer add(@RequestBody MyItemConfigVo myItemConfig);


    /**
     * @param itemId
     * @return
     */
    @GetMapping("/myItemConfig/manage/delete")
    public Integer delete(@RequestParam(value = "itemId") Long itemId);

    /**
     * @param itemId   根据id，使其显示
     * @param showable 是否显示:0不显示,1显示（默认为0）
     * @return
     */
    @GetMapping("/myItemConfig/manage/showable")
    public Integer showable(@RequestParam(value = "itemId") Long itemId, @RequestParam(value = "showable") Integer showable);

    @PostMapping("/myItemConfig/manage/update")
    public Integer update(@RequestBody MyItemConfigVo myItemConfig);

    @GetMapping("/myItemConfig/manage/queryById")
    public MyItemConfigVO queryById(@RequestParam(value = "id") Long id);

    /**
     * 根据条件，查询相应的list
     *
     * @param name         项目名称
     * @param showable     是否显示:0不显示,1显示（默认为0）
     * @param terminalType 终端类型：1-PC端、2-移动端 3-PC端&移动端
     * @return
     */
    @GetMapping("/myItemConfig/manage/queryMyItemConfigByCondition")
    public List<MyItemConfigVO> queryMyitemConfigByCondition(@RequestParam(value = "name", required = false) String name,
                                                             @RequestParam(value = "showable", required = false) Integer showable,
                                                             @RequestParam(value = "terminalType", required = false) Integer terminalType);

    /**
     * @param id   栏目id
     * @param type 1-代表上移  2-代表下移
     * @return
     */
    @GetMapping("/myItemConfig/manage/move")
    public Integer move(@RequestParam(value = "type") Integer type, @RequestParam(value = "id") Long id);
}
