package com.yizhi.site.application.vo.domain;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * APP版本控制表
 * </p>
 *
 * @author lingye
 * @since 2019-07-22
 */
@Data
@Api(tags = "AppVersionEntityVo", description = "APP版本控制表")
public class AppVersionVo  {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "应用安装包地址")
    private String appUrl;

    @ApiModelProperty(value = "类型：1 IOS，2 Android")
    private Integer type;

    @ApiModelProperty(value = "站点id")
    private Long siteId;

    @ApiModelProperty(value = "站点Code")
    private String siteCode;

    @ApiModelProperty(value = "公司Code")
    private String companyCode;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "版本号")
    private String version;

    @ApiModelProperty(value = "app_des")
    private String appDes;

    @ApiModelProperty(value = "删除标记,1 删除，0 正常")
    private Integer delFlag;

    protected Serializable pkVal() {
        return this.id;
    }

}
