package com.yizhi.site.application.vo.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@ApiModel(value = "PortalImageEntityVo", description = "轮播项图片")
@Data
public class PortalImageVo {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "主键")
	private Long id;

	@ApiModelProperty(value = "轮播图ID")
	private Long bannerId;

	@ApiModelProperty(value = "图片标题")
	private String imgTitle;

	@ApiModelProperty(value = "存放图片路径")
	private String bannerPath;

	@ApiModelProperty(value = "跳转后的功能id, pc端外部链接")
	private String linkUrl;
	
	
	//王飞达注释首页的类型, /首页的类型, 1：课程  2：考试   3：培训  4：外部链接 5:新闻 6:营销  8:首页不选类型时候（仅仅图片）   0:不是首页';2019-01-14
	@ApiModelProperty(value = "//首页的类型, 1：课程  2：考试   3：培训  4：外部链接 5:活动 6:调研 7:新闻 8:首页不选类型时候（仅仅图片）   0:不是首页")
	private Integer homeType;
	
	@ApiModelProperty(value = "指定上架时间")
	private Date addTime;

	@ApiModelProperty(value = "排序")
	private Integer sort;

	@ApiModelProperty(value = "0删除 1: 上架 2：下架")
	private Integer state;

	@ApiModelProperty(value = "创建时间")
	private Date createTime;

	@ApiModelProperty(value = "创建人")
	private Long createById;

	@ApiModelProperty(value = "创建人姓名")
	private String createByName;

	@ApiModelProperty(value = "修改时间")
	private Date updateTime;

	@ApiModelProperty(value = "修改人")
	private Long updateById;

	@ApiModelProperty(value = "修改人姓名")
	private String updateByName;


	protected Serializable pkVal() {
		return this.id;
	}
}
