package com.yizhi.site.application.vo.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 门户主题色配置
 * </p>
 *
 * @author fulan123
 * @since 2020-08-12
 */
@Data
@ApiModel(value = "PortalThemeColorEntityVo", description = "门户主题色配置")
public class PortalThemeColorVo {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "主键")
	private Long id;

    @ApiModelProperty(value = "企业id")
	private Long companyId;

    @ApiModelProperty(value = "站点id")
	private Long siteId;

    @ApiModelProperty(value = "终端类型：1 后台管理端  ；2 PC端 ； 3 移动端")
	private Integer terminalType;

    @ApiModelProperty(value = "主题色")
	private String themeColor;

    @ApiModelProperty(value = "辅助色")
	private String auxiliarColor;

    @ApiModelProperty(value = "创建用户")
	private Long createById;

    @ApiModelProperty(value = "创建时间")
	private Date createTime;

    @ApiModelProperty(value = "更新用户")
	private Long updateById;

    @ApiModelProperty(value = "更新时间")
	private Date updateTime;



}
