package com.yizhi.site.application.vo.site;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@Api(tags = "InfoVO", description = "资讯请求json")
public class InfoVO extends ContextVO {

	@ApiModelProperty(value = "当前页")
	private Integer pageNo;

	@ApiModelProperty(value = "每页个数")
	private Integer pageSize;
	
	@ApiModelProperty(value = "资讯名称")
	private String typeName;

	@ApiModelProperty(value = "资讯父类型")
	private Long typeOne;

	@ApiModelProperty(value = "资讯子类型")
	private Long typeTwo;
	
	@ApiModelProperty(value = "终端名称, PC：PC，APP： MOBILE, 微信: WECHAT")
	private String terminalName;
	
	@ApiModelProperty(value = "轮播图所属栏目, MARKET:营销, TRAIN:培训, HOMEPAGE:首页, COURSE:课程, NEWS:新闻资讯")
	private String bannerName;
	
	@ApiModelProperty(value = "层级")
	private Integer level;
	
	@ApiModelProperty(value = "绑定的业务的ID")
	private Long relationId;
}
