package com.yizhi.site.application.vo.site;

import java.io.Serializable;
import java.util.Date;
import java.util.List;


import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class ReportParamVO implements Serializable {
	
	@ApiModelProperty(value = "终端id")
	private Long terminalId;
	
	@ApiModelProperty(value = "选中的报告")
	private List<ReportVO> reportList;
	
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class ReportVO implements Serializable {

    	@ApiModelProperty(value = "报告id")
    	private Long reportId;
    	
    	@ApiModelProperty(value = "报告名称")
    	private String reportName;
    	
    	@ApiModelProperty(value = "首页推送开始时间")
    	private Date startPush;
    	
    	@ApiModelProperty(value = "首页推送结束时间")
    	private Date endPush;

    }
}
