package com.yizhi.site.application.vo.site;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 站点
 * </p>
 *
 * @author fulan123
 * @since 2018-03-08
 */
@Data
@Api(tags = "TrSitePageVO", description = "站点传输对象")
public class TrSitePageVO {

    @ApiModelProperty(value = "id", notes = "修改时传")
    private Long id;

    @ApiModelProperty(value = "配置的站点id")
    private Long studentSiteId;

    @ApiModelProperty(value = "站点名称")
    private String name;

    @ApiModelProperty(value = "编码")
    private String code;

    @ApiModelProperty(value = "标识")
    private String logo;

    @ApiModelProperty(value = "管辖区id")
    private Long userGroupId;

    @ApiModelProperty(value = "管辖区名称")
    private String userGroupName;

    @ApiModelProperty(value = "站点总管理员账号id")
    private Long adminAccountId;

    @ApiModelProperty(value = "域名")
    private String domain;

    @ApiModelProperty(value = "是否开通")
    private Boolean enabled;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "成员类型(1:子站点2:业务站点)")
    private Integer type;

    @ApiModelProperty(value = "备案")
    private String records;

    @ApiModelProperty(value = "第几页")
    private Integer pageNo = 1;

    @ApiModelProperty(value = "页内条数")
    private Integer pageSize = 10;
}
