package com.yizhi.site.application.controller;


import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.domain.MyItemConfig;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.site.application.service.MyItemConfigService;
import com.yizhi.site.application.vo.site.MyItemConfigVO;
import io.swagger.annotations.Api;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 我的配置 前端控制器
 * </p>
 *
 * @author hutao123
 * @since 2019-02-21
 */
@Api(tags = "管理端-我的配置", description = "我的配置")
@RestController
@RequestMapping("/myItemConfig/manage")
public class MyItemConfigManageComtroller {
    public static final Integer OPERATION_FAIL = 0;
    public static final Integer OPERATION_SUCCESS = 1;
    public static final Integer ID_NOT_EXSIT = -1;
    @Autowired
    MyItemConfigService myItemConfigService;
    @Autowired
    IdGenerator idGenerator;

    @PostMapping("/add")
    public Integer add(@RequestBody MyItemConfig myItemConfig) {
        RequestContext context = ContextHolder.get();
        myItemConfig.setSiteId(context.getSiteId());
        myItemConfig.setDeleted(0); //默认为不删除
        myItemConfig.setShowable(0);//默认不显示
        myItemConfig.setId(idGenerator.generate());
        myItemConfig.setCreateById(context.getAccountId());
        myItemConfig.setCreateByName(context.getAccountName());

        if (myItemConfigService.insert(myItemConfig)) {
            return OPERATION_SUCCESS;
        }
        return OPERATION_FAIL;
    }


    /**
     * @param itemId
     * @return
     */
    @GetMapping("/delete")
    public Integer delete(@RequestParam(value = "itemId") Long itemId) {
        if (null == itemId) {
            return ID_NOT_EXSIT;
        }
        MyItemConfig myItemConfig = myItemConfigService.selectById(itemId);
        if (null != myItemConfig) {
            myItemConfig.setShowable(0);
            myItemConfig.setDeleted(1);
            if (myItemConfigService.updateById(myItemConfig)) {
                return OPERATION_SUCCESS;
            }
        }
        return OPERATION_FAIL;
    }

    /**
     * @param itemId
     * @param showable 是否显示:0不显示,1显示（默认为0）
     * @return
     */
    @GetMapping("/showable")
    public Integer showable(@RequestParam(value = "itemId") Long itemId, @RequestParam(value = "showable") Integer showable) {
        if (null == itemId) {
            return ID_NOT_EXSIT;
        }
        MyItemConfig myItemConfig = myItemConfigService.selectById(itemId);
        if (null != myItemConfig) {
            myItemConfig.setShowable(showable);
            if (myItemConfigService.updateById(myItemConfig)) {
                return OPERATION_SUCCESS;
            }
        }
        return OPERATION_FAIL;
    }

    @PostMapping("/update")
    public Integer update(@RequestBody MyItemConfig myItemConfig) {
        if (null == myItemConfig.getId()) {
            return ID_NOT_EXSIT;
        }
        MyItemConfig myItemConfigTemp = myItemConfigService.selectById(myItemConfig.getId());
        if (null != myItemConfigTemp) {
            MyItemConfig myItemConfig1 = new MyItemConfig();
            myItemConfig1.setId(myItemConfig.getId());
            myItemConfig1.setShowable(myItemConfig.getShowable());
            if (myItemConfigService.updateById(myItemConfig1)) {
                return OPERATION_SUCCESS;
            }
        }
        return OPERATION_FAIL;
    }

    @GetMapping("/queryById")
    public MyItemConfigVO queryById(@RequestParam(value = "id") Long id) {
        MyItemConfigVO vo = new MyItemConfigVO();
        if (null == id) {
            return vo;
        }
        MyItemConfig myItemConfigTemp = myItemConfigService.selectById(id);
        BeanUtils.copyProperties(myItemConfigTemp, vo);
        return vo;
    }

    /**
     * 根据条件，查询相应的list
     *
     * @param name         项目名称
     * @param showable     是否显示:0不显示,1显示（默认为0）
     * @param terminalType 终端类型：1-PC端、2-移动端 3-PC端&移动端
     * @return
     */
    @GetMapping("/queryMyItemConfigByCondition")
    public List<MyItemConfigVO> queryMyitemConfigByCondition(@RequestParam(value = "name", required = false) String name,
                                                             @RequestParam(value = "showable", required = false) Integer showable,
                                                             @RequestParam(value = "terminalType", required = false) Integer terminalType) {
        List<MyItemConfig> itemConfig = myItemConfigService.queryMyitemConfigByCondition(name, showable, terminalType);
        List<MyItemConfigVO> voList = new ArrayList<>();

        itemConfig.forEach(a -> {
            MyItemConfigVO vo = new MyItemConfigVO();
            BeanUtils.copyProperties(a, vo);
            switch (a.getTerminalType()) {
                case 1:
                    vo.setTerminalTypeString("PC端");
                    break;
                case 2:
                    vo.setTerminalTypeString("移动端");
                    break;
                case 3:
                    vo.setTerminalTypeString("PC端&移动端");
                    break;
                default:
                    vo.setTerminalTypeString("终端类型值只有1、2、3");
                    break;
            }
            voList.add(vo);
        });
        return voList;

    }

    /**
     * @param id   栏目id
     * @param type 1-代表上移  2-代表下移
     * @return
     */
    @GetMapping("/move")
    public Integer move(@RequestParam(value = "type") Integer type, @RequestParam(value = "id") Long id) {

        return myItemConfigService.move(id, type);
    }

}